package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, U) -> int}.
 *
 * @param <U> the type of argument 2
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortObjToIntE<U, E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh argument 1
     * @param u argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    int call(short sh, U u) throws E;

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (U) -> int}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (U u) -> int} that calls
     *      {@code f.call(sh, u)} and returns the result.
     */
    static <U, E extends Exception> net.mintern.functions.unary.checked.ObjToIntE<U, E>
    bind(ShortObjToIntE<U, E> f, short sh) {
        return (u) -> f.call(sh, u);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (U) -> int}.
     *
     * @param sh argument 1
     * @return a new function {@code (U u) -> int} that calls
     *      {@code this.call(sh, u)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ObjToIntE<U, E> bind(short sh) {
        return ShortObjToIntE.bind(this, sh);
    }

    /**
     * Binds {@code (u)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> int}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param u argument 2
     * @return a new function {@code (short sh) -> int} that calls
     *      {@code f.call(sh, u)} and returns the result.
     */
    static <U, E extends Exception> net.mintern.functions.unary.checked.ShortToIntE<E>
    rbind(ShortObjToIntE<U, E> f, U u) {
        return (sh) -> f.call(sh, u);
    }

    /**
     * Binds {@code (u)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> int}.
     *
     * @param u argument 2
     * @return a new function {@code (short sh) -> int} that calls
     *      {@code this.call(sh, u)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToIntE<E> rbind(U u) {
        return ShortObjToIntE.rbind(this, u);
    }

    /**
     * Binds {@code (sh, u)} to {@code f}, returning a new function
     * of type {@code () -> int}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @param u argument 2
     * @return a new function {@code () -> int} that calls
     *      {@code f.call(sh, u)} and returns the result.
     */
    static <U, E extends Exception> net.mintern.functions.nullary.checked.NilToIntE<E>
    bind(ShortObjToIntE<U, E> f, short sh, U u) {
        return () -> f.call(sh, u);
    }

    /**
     * Binds {@code (sh, u)} to {@code this}, returning a new function
     * of type {@code () -> int}.
     *
     * @param sh argument 1
     * @param u argument 2
     * @return a new function {@code () -> int} that calls
     *      {@code this.call(sh, u)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToIntE<E> bind(short sh, U u) {
        return ShortObjToIntE.bind(this, sh, u);
    }
}
