package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, short) -> byte}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortShortToByteE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh1 argument 1
     * @param sh2 argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    byte call(short sh1, short sh2) throws E;

    /**
     * Binds {@code (sh1)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> byte}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh1 argument 1
     * @return a new function {@code (short sh2) -> byte} that calls
     *      {@code f.call(sh1, sh2)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToByteE<E>
    bind(ShortShortToByteE<E> f, short sh1) {
        return (sh2) -> f.call(sh1, sh2);
    }

    /**
     * Binds {@code (sh1)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> byte}.
     *
     * @param sh1 argument 1
     * @return a new function {@code (short sh2) -> byte} that calls
     *      {@code this.call(sh1, sh2)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToByteE<E> bind(short sh1) {
        return ShortShortToByteE.bind(this, sh1);
    }

    /**
     * Binds {@code (sh2)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> byte}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh2 argument 2
     * @return a new function {@code (short sh1) -> byte} that calls
     *      {@code f.call(sh1, sh2)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToByteE<E>
    rbind(ShortShortToByteE<E> f, short sh2) {
        return (sh1) -> f.call(sh1, sh2);
    }

    /**
     * Binds {@code (sh2)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> byte}.
     *
     * @param sh2 argument 2
     * @return a new function {@code (short sh1) -> byte} that calls
     *      {@code this.call(sh1, sh2)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToByteE<E> rbind(short sh2) {
        return ShortShortToByteE.rbind(this, sh2);
    }

    /**
     * Binds {@code (sh1, sh2)} to {@code f}, returning a new function
     * of type {@code () -> byte}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh1 argument 1
     * @param sh2 argument 2
     * @return a new function {@code () -> byte} that calls
     *      {@code f.call(sh1, sh2)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToByteE<E>
    bind(ShortShortToByteE<E> f, short sh1, short sh2) {
        return () -> f.call(sh1, sh2);
    }

    /**
     * Binds {@code (sh1, sh2)} to {@code this}, returning a new function
     * of type {@code () -> byte}.
     *
     * @param sh1 argument 1
     * @param sh2 argument 2
     * @return a new function {@code () -> byte} that calls
     *      {@code this.call(sh1, sh2)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToByteE<E> bind(short sh1, short sh2) {
        return ShortShortToByteE.bind(this, sh1, sh2);
    }
}
