package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, short) -> char}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortShortToCharE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh1 argument 1
     * @param sh2 argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    char call(short sh1, short sh2) throws E;

    /**
     * Binds {@code (sh1)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> char}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh1 argument 1
     * @return a new function {@code (short sh2) -> char} that calls
     *      {@code f.call(sh1, sh2)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToCharE<E>
    bind(ShortShortToCharE<E> f, short sh1) {
        return (sh2) -> f.call(sh1, sh2);
    }

    /**
     * Binds {@code (sh1)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> char}.
     *
     * @param sh1 argument 1
     * @return a new function {@code (short sh2) -> char} that calls
     *      {@code this.call(sh1, sh2)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToCharE<E> bind(short sh1) {
        return ShortShortToCharE.bind(this, sh1);
    }

    /**
     * Binds {@code (sh2)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> char}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh2 argument 2
     * @return a new function {@code (short sh1) -> char} that calls
     *      {@code f.call(sh1, sh2)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToCharE<E>
    rbind(ShortShortToCharE<E> f, short sh2) {
        return (sh1) -> f.call(sh1, sh2);
    }

    /**
     * Binds {@code (sh2)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> char}.
     *
     * @param sh2 argument 2
     * @return a new function {@code (short sh1) -> char} that calls
     *      {@code this.call(sh1, sh2)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToCharE<E> rbind(short sh2) {
        return ShortShortToCharE.rbind(this, sh2);
    }

    /**
     * Binds {@code (sh1, sh2)} to {@code f}, returning a new function
     * of type {@code () -> char}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh1 argument 1
     * @param sh2 argument 2
     * @return a new function {@code () -> char} that calls
     *      {@code f.call(sh1, sh2)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToCharE<E>
    bind(ShortShortToCharE<E> f, short sh1, short sh2) {
        return () -> f.call(sh1, sh2);
    }

    /**
     * Binds {@code (sh1, sh2)} to {@code this}, returning a new function
     * of type {@code () -> char}.
     *
     * @param sh1 argument 1
     * @param sh2 argument 2
     * @return a new function {@code () -> char} that calls
     *      {@code this.call(sh1, sh2)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToCharE<E> bind(short sh1, short sh2) {
        return ShortShortToCharE.bind(this, sh1, sh2);
    }
}
