package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, short) -> long}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortShortToLongE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh1 argument 1
     * @param sh2 argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    long call(short sh1, short sh2) throws E;

    /**
     * Binds {@code (sh1)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> long}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh1 argument 1
     * @return a new function {@code (short sh2) -> long} that calls
     *      {@code f.call(sh1, sh2)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToLongE<E>
    bind(ShortShortToLongE<E> f, short sh1) {
        return (sh2) -> f.call(sh1, sh2);
    }

    /**
     * Binds {@code (sh1)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> long}.
     *
     * @param sh1 argument 1
     * @return a new function {@code (short sh2) -> long} that calls
     *      {@code this.call(sh1, sh2)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToLongE<E> bind(short sh1) {
        return ShortShortToLongE.bind(this, sh1);
    }

    /**
     * Binds {@code (sh2)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> long}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh2 argument 2
     * @return a new function {@code (short sh1) -> long} that calls
     *      {@code f.call(sh1, sh2)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToLongE<E>
    rbind(ShortShortToLongE<E> f, short sh2) {
        return (sh1) -> f.call(sh1, sh2);
    }

    /**
     * Binds {@code (sh2)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> long}.
     *
     * @param sh2 argument 2
     * @return a new function {@code (short sh1) -> long} that calls
     *      {@code this.call(sh1, sh2)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToLongE<E> rbind(short sh2) {
        return ShortShortToLongE.rbind(this, sh2);
    }

    /**
     * Binds {@code (sh1, sh2)} to {@code f}, returning a new function
     * of type {@code () -> long}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh1 argument 1
     * @param sh2 argument 2
     * @return a new function {@code () -> long} that calls
     *      {@code f.call(sh1, sh2)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToLongE<E>
    bind(ShortShortToLongE<E> f, short sh1, short sh2) {
        return () -> f.call(sh1, sh2);
    }

    /**
     * Binds {@code (sh1, sh2)} to {@code this}, returning a new function
     * of type {@code () -> long}.
     *
     * @param sh1 argument 1
     * @param sh2 argument 2
     * @return a new function {@code () -> long} that calls
     *      {@code this.call(sh1, sh2)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToLongE<E> bind(short sh1, short sh2) {
        return ShortShortToLongE.bind(this, sh1, sh2);
    }
}
