package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, short) -> R}.
 *
 * @param <R> the type of the return value
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortShortToObjE<R, E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh1 argument 1
     * @param sh2 argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    R call(short sh1, short sh2) throws E;

    /**
     * Binds {@code (sh1)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> R}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh1 argument 1
     * @return a new function {@code (short sh2) -> R} that calls
     *      {@code f.call(sh1, sh2)} and returns the result.
     */
    static <R, E extends Exception> net.mintern.functions.unary.checked.ShortToObjE<R, E>
    bind(ShortShortToObjE<R, E> f, short sh1) {
        return (sh2) -> f.call(sh1, sh2);
    }

    /**
     * Binds {@code (sh1)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> R}.
     *
     * @param sh1 argument 1
     * @return a new function {@code (short sh2) -> R} that calls
     *      {@code this.call(sh1, sh2)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToObjE<R, E> bind(short sh1) {
        return ShortShortToObjE.bind(this, sh1);
    }

    /**
     * Binds {@code (sh2)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> R}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh2 argument 2
     * @return a new function {@code (short sh1) -> R} that calls
     *      {@code f.call(sh1, sh2)} and returns the result.
     */
    static <R, E extends Exception> net.mintern.functions.unary.checked.ShortToObjE<R, E>
    rbind(ShortShortToObjE<R, E> f, short sh2) {
        return (sh1) -> f.call(sh1, sh2);
    }

    /**
     * Binds {@code (sh2)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> R}.
     *
     * @param sh2 argument 2
     * @return a new function {@code (short sh1) -> R} that calls
     *      {@code this.call(sh1, sh2)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToObjE<R, E> rbind(short sh2) {
        return ShortShortToObjE.rbind(this, sh2);
    }

    /**
     * Binds {@code (sh1, sh2)} to {@code f}, returning a new function
     * of type {@code () -> R}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh1 argument 1
     * @param sh2 argument 2
     * @return a new function {@code () -> R} that calls
     *      {@code f.call(sh1, sh2)} and returns the result.
     */
    @SuppressWarnings("unchecked") // maven spuriously warns about a type error in this case
    static <R, E extends Exception> net.mintern.functions.nullary.checked.NilToObjE<R, E>
    bind(ShortShortToObjE<R, E> f, short sh1, short sh2) {
        return () -> f.call(sh1, sh2);
    }

    /**
     * Binds {@code (sh1, sh2)} to {@code this}, returning a new function
     * of type {@code () -> R}.
     *
     * @param sh1 argument 1
     * @param sh2 argument 2
     * @return a new function {@code () -> R} that calls
     *      {@code this.call(sh1, sh2)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToObjE<R, E> bind(short sh1, short sh2) {
        return ShortShortToObjE.bind(this, sh1, sh2);
    }
}
