/*
 * Decompiled with CFR 0.152.
 */
package net.mintern.functions.binary;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Function;
import net.mintern.functions.binary.checked.ShortIntToObjE;
import net.mintern.functions.nullary.NilToObj;
import net.mintern.functions.unary.IntToObj;
import net.mintern.functions.unary.ShortToObj;

@FunctionalInterface
public interface ShortIntToObj<R>
extends ShortIntToObjE<R, RuntimeException> {
    public static <R, E extends Exception> ShortIntToObj<R> unchecked(Function<? super E, RuntimeException> toRuntime, ShortIntToObjE<R, E> f) {
        return (sh, i) -> {
            try {
                return f.call(sh, i);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw (RuntimeException)toRuntime.apply((Object)e);
            }
        };
    }

    public static <R, E extends Exception> ShortIntToObj<R> unchecked(ShortIntToObjE<R, E> f) {
        return ShortIntToObj.unchecked(RuntimeException::new, f);
    }

    public static <R, E extends IOException> ShortIntToObj<R> uncheckedIO(ShortIntToObjE<R, E> f) {
        return ShortIntToObj.unchecked(UncheckedIOException::new, f);
    }

    public static <R> IntToObj<R> bind(ShortIntToObj<R> f, short sh) {
        return i -> f.call(sh, i);
    }

    default public IntToObj<R> bind(short sh) {
        return ShortIntToObj.bind(this, sh);
    }

    public static <R> ShortToObj<R> rbind(ShortIntToObj<R> f, int i) {
        return sh -> f.call(sh, i);
    }

    default public ShortToObj<R> rbind(int i) {
        return ShortIntToObj.rbind(this, i);
    }

    public static <R> NilToObj<R> bind(ShortIntToObj<R> f, short sh, int i) {
        return () -> f.call(sh, i);
    }

    default public NilToObj<R> bind(short sh, int i) {
        return ShortIntToObj.bind(this, sh, i);
    }
}

