package net.mintern.functions.unary;

/**
 * An operation of type {@code (double) -> double}.
 *
 */
@FunctionalInterface
public interface DblToDbl extends
        net.mintern.functions.unary.checked.DblToDblE<RuntimeException>,
        java.util.function.DoubleUnaryOperator {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.unary.checked.DblToDblE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> DblToDbl unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.unary.checked.DblToDblE<E> f) {
        return (d) -> {
            try {
                return f.call(d);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> DblToDbl unchecked(
            net.mintern.functions.unary.checked.DblToDblE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> DblToDbl uncheckedIO(
            net.mintern.functions.unary.checked.DblToDblE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (d)} to {@code f}, returning a new function
     * of type {@code () -> double}.
     *
     * @param f the unbound function
     * @param d the argument
     * @return a new function {@code () -> double} that calls
     *      {@code f.call(d)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToDbl
    bind(DblToDbl f, double d) {
        return () -> f.call(d);
    }

    /**
     * Binds {@code (d)} to {@code this}, returning a new function
     * of type {@code () -> double}.
     *
     * @param d the argument
     * @return a new function {@code () -> double} that calls
     *      {@code this.call(d)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToDbl bind(double d) {
        return DblToDbl.bind(this, d);
    }

    /**
     * Allows {@code this} to act as a {@code DoubleUnaryOperator}.
     *
     * @param d the argument
     * @return the result of the operation
     */
    @Override
    default double applyAsDouble(double d) {
        return call(d);
    }
}
