package net.mintern.functions.unary;

/**
 * An operation of type {@code (double) -> int}.
 *
 */
@FunctionalInterface
public interface DblToInt extends
        net.mintern.functions.unary.checked.DblToIntE<RuntimeException>,
        java.util.function.DoubleToIntFunction {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.unary.checked.DblToIntE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> DblToInt unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.unary.checked.DblToIntE<E> f) {
        return (d) -> {
            try {
                return f.call(d);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> DblToInt unchecked(
            net.mintern.functions.unary.checked.DblToIntE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> DblToInt uncheckedIO(
            net.mintern.functions.unary.checked.DblToIntE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (d)} to {@code f}, returning a new function
     * of type {@code () -> int}.
     *
     * @param f the unbound function
     * @param d the argument
     * @return a new function {@code () -> int} that calls
     *      {@code f.call(d)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToInt
    bind(DblToInt f, double d) {
        return () -> f.call(d);
    }

    /**
     * Binds {@code (d)} to {@code this}, returning a new function
     * of type {@code () -> int}.
     *
     * @param d the argument
     * @return a new function {@code () -> int} that calls
     *      {@code this.call(d)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToInt bind(double d) {
        return DblToInt.bind(this, d);
    }

    /**
     * Allows {@code this} to act as a {@code DoubleToIntFunction}.
     *
     * @param d the argument
     * @return the result of the operation
     */
    @Override
    default int applyAsInt(double d) {
        return call(d);
    }
}
