package net.mintern.functions.unary;

/**
 * An operation of type {@code (double) -> long}.
 *
 */
@FunctionalInterface
public interface DblToLong extends
        net.mintern.functions.unary.checked.DblToLongE<RuntimeException>,
        java.util.function.DoubleToLongFunction {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.unary.checked.DblToLongE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> DblToLong unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.unary.checked.DblToLongE<E> f) {
        return (d) -> {
            try {
                return f.call(d);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> DblToLong unchecked(
            net.mintern.functions.unary.checked.DblToLongE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> DblToLong uncheckedIO(
            net.mintern.functions.unary.checked.DblToLongE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (d)} to {@code f}, returning a new function
     * of type {@code () -> long}.
     *
     * @param f the unbound function
     * @param d the argument
     * @return a new function {@code () -> long} that calls
     *      {@code f.call(d)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToLong
    bind(DblToLong f, double d) {
        return () -> f.call(d);
    }

    /**
     * Binds {@code (d)} to {@code this}, returning a new function
     * of type {@code () -> long}.
     *
     * @param d the argument
     * @return a new function {@code () -> long} that calls
     *      {@code this.call(d)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToLong bind(double d) {
        return DblToLong.bind(this, d);
    }

    /**
     * Allows {@code this} to act as a {@code DoubleToLongFunction}.
     *
     * @param d the argument
     * @return the result of the operation
     */
    @Override
    default long applyAsLong(double d) {
        return call(d);
    }
}
