package net.mintern.functions.unary;

/**
 * An operation of type {@code (double) -> void}.
 *
 */
@FunctionalInterface
public interface DblToNil extends
        net.mintern.functions.unary.checked.DblToNilE<RuntimeException>,
        java.util.function.DoubleConsumer {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.unary.checked.DblToNilE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> DblToNil unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.unary.checked.DblToNilE<E> f) {
        return (d) -> {
            try {
                f.call(d);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> DblToNil unchecked(
            net.mintern.functions.unary.checked.DblToNilE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> DblToNil uncheckedIO(
            net.mintern.functions.unary.checked.DblToNilE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (d)} to {@code f}, returning a new function
     * of type {@code () -> void}.
     *
     * @param f the unbound function
     * @param d the argument
     * @return a new function {@code () -> void} that calls
     *      {@code f.call(d)}.
     */
    static  net.mintern.functions.nullary.NilToNil
    bind(DblToNil f, double d) {
        return () -> f.call(d);
    }

    /**
     * Binds {@code (d)} to {@code this}, returning a new function
     * of type {@code () -> void}.
     *
     * @param d the argument
     * @return a new function {@code () -> void} that calls
     *      {@code this.call(d)}.
     */
    @Override
    default net.mintern.functions.nullary.NilToNil bind(double d) {
        return DblToNil.bind(this, d);
    }

    /**
     * Allows {@code this} to act as a {@code DoubleConsumer}.
     *
     * @param d the argument
     */
    @Override
    default void accept(double d) {
        call(d);
    }
}
