package net.mintern.functions.unary;

/**
 * An operation of type {@code (double) -> R}.
 *
 * @param <R> the type of the return value
 */
@FunctionalInterface
public interface DblToObj<R> extends
        net.mintern.functions.unary.checked.DblToObjE<R, RuntimeException>,
        java.util.function.DoubleFunction<R> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.unary.checked.DblToObjE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <R, E extends Exception> DblToObj<R> unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.unary.checked.DblToObjE<R, E> f) {
        return (d) -> {
            try {
                return f.call(d);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <R, E extends Exception> DblToObj<R> unchecked(
            net.mintern.functions.unary.checked.DblToObjE<R, E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <R, E extends java.io.IOException> DblToObj<R> uncheckedIO(
            net.mintern.functions.unary.checked.DblToObjE<R, E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (d)} to {@code f}, returning a new function
     * of type {@code () -> R}.
     *
     * @param <R> the type of the return value
     * @param f the unbound function
     * @param d the argument
     * @return a new function {@code () -> R} that calls
     *      {@code f.call(d)} and returns the result.
     */
    static <R> net.mintern.functions.nullary.NilToObj<R>
    bind(DblToObj<R> f, double d) {
        return () -> f.call(d);
    }

    /**
     * Binds {@code (d)} to {@code this}, returning a new function
     * of type {@code () -> R}.
     *
     * @param d the argument
     * @return a new function {@code () -> R} that calls
     *      {@code this.call(d)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToObj<R> bind(double d) {
        return DblToObj.bind(this, d);
    }

    /**
     * Allows {@code this} to act as a {@code DoubleFunction<R>}.
     *
     * @param d the argument
     * @return the result of the operation
     */
    @Override
    default R apply(double d) {
        return call(d);
    }
}
