package net.mintern.functions.unary;

/**
 * An operation of type {@code (int) -> long}.
 *
 */
@FunctionalInterface
public interface IntToLong extends
        net.mintern.functions.unary.checked.IntToLongE<RuntimeException>,
        java.util.function.IntToLongFunction {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.unary.checked.IntToLongE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> IntToLong unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.unary.checked.IntToLongE<E> f) {
        return (i) -> {
            try {
                return f.call(i);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> IntToLong unchecked(
            net.mintern.functions.unary.checked.IntToLongE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> IntToLong uncheckedIO(
            net.mintern.functions.unary.checked.IntToLongE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (i)} to {@code f}, returning a new function
     * of type {@code () -> long}.
     *
     * @param f the unbound function
     * @param i the argument
     * @return a new function {@code () -> long} that calls
     *      {@code f.call(i)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToLong
    bind(IntToLong f, int i) {
        return () -> f.call(i);
    }

    /**
     * Binds {@code (i)} to {@code this}, returning a new function
     * of type {@code () -> long}.
     *
     * @param i the argument
     * @return a new function {@code () -> long} that calls
     *      {@code this.call(i)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToLong bind(int i) {
        return IntToLong.bind(this, i);
    }

    /**
     * Allows {@code this} to act as a {@code IntToLongFunction}.
     *
     * @param i the argument
     * @return the result of the operation
     */
    @Override
    default long applyAsLong(int i) {
        return call(i);
    }
}
