package net.mintern.functions.unary;

/**
 * An operation of type {@code (int) -> R}.
 *
 * @param <R> the type of the return value
 */
@FunctionalInterface
public interface IntToObj<R> extends
        net.mintern.functions.unary.checked.IntToObjE<R, RuntimeException>,
        java.util.function.IntFunction<R> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.unary.checked.IntToObjE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <R, E extends Exception> IntToObj<R> unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.unary.checked.IntToObjE<R, E> f) {
        return (i) -> {
            try {
                return f.call(i);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <R, E extends Exception> IntToObj<R> unchecked(
            net.mintern.functions.unary.checked.IntToObjE<R, E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <R, E extends java.io.IOException> IntToObj<R> uncheckedIO(
            net.mintern.functions.unary.checked.IntToObjE<R, E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (i)} to {@code f}, returning a new function
     * of type {@code () -> R}.
     *
     * @param <R> the type of the return value
     * @param f the unbound function
     * @param i the argument
     * @return a new function {@code () -> R} that calls
     *      {@code f.call(i)} and returns the result.
     */
    static <R> net.mintern.functions.nullary.NilToObj<R>
    bind(IntToObj<R> f, int i) {
        return () -> f.call(i);
    }

    /**
     * Binds {@code (i)} to {@code this}, returning a new function
     * of type {@code () -> R}.
     *
     * @param i the argument
     * @return a new function {@code () -> R} that calls
     *      {@code this.call(i)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToObj<R> bind(int i) {
        return IntToObj.bind(this, i);
    }

    /**
     * Allows {@code this} to act as a {@code IntFunction<R>}.
     *
     * @param i the argument
     * @return the result of the operation
     */
    @Override
    default R apply(int i) {
        return call(i);
    }
}
