package net.mintern.functions.unary;

/**
 * An operation of type {@code (long) -> double}.
 *
 */
@FunctionalInterface
public interface LongToDbl extends
        net.mintern.functions.unary.checked.LongToDblE<RuntimeException>,
        java.util.function.LongToDoubleFunction {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.unary.checked.LongToDblE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> LongToDbl unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.unary.checked.LongToDblE<E> f) {
        return (l) -> {
            try {
                return f.call(l);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> LongToDbl unchecked(
            net.mintern.functions.unary.checked.LongToDblE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> LongToDbl uncheckedIO(
            net.mintern.functions.unary.checked.LongToDblE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (l)} to {@code f}, returning a new function
     * of type {@code () -> double}.
     *
     * @param f the unbound function
     * @param l the argument
     * @return a new function {@code () -> double} that calls
     *      {@code f.call(l)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToDbl
    bind(LongToDbl f, long l) {
        return () -> f.call(l);
    }

    /**
     * Binds {@code (l)} to {@code this}, returning a new function
     * of type {@code () -> double}.
     *
     * @param l the argument
     * @return a new function {@code () -> double} that calls
     *      {@code this.call(l)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToDbl bind(long l) {
        return LongToDbl.bind(this, l);
    }

    /**
     * Allows {@code this} to act as a {@code LongToDoubleFunction}.
     *
     * @param l the argument
     * @return the result of the operation
     */
    @Override
    default double applyAsDouble(long l) {
        return call(l);
    }
}
