package net.mintern.functions.unary;

/**
 * An operation of type {@code (long) -> int}.
 *
 */
@FunctionalInterface
public interface LongToInt extends
        net.mintern.functions.unary.checked.LongToIntE<RuntimeException>,
        java.util.function.LongToIntFunction {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.unary.checked.LongToIntE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> LongToInt unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.unary.checked.LongToIntE<E> f) {
        return (l) -> {
            try {
                return f.call(l);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> LongToInt unchecked(
            net.mintern.functions.unary.checked.LongToIntE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> LongToInt uncheckedIO(
            net.mintern.functions.unary.checked.LongToIntE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (l)} to {@code f}, returning a new function
     * of type {@code () -> int}.
     *
     * @param f the unbound function
     * @param l the argument
     * @return a new function {@code () -> int} that calls
     *      {@code f.call(l)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToInt
    bind(LongToInt f, long l) {
        return () -> f.call(l);
    }

    /**
     * Binds {@code (l)} to {@code this}, returning a new function
     * of type {@code () -> int}.
     *
     * @param l the argument
     * @return a new function {@code () -> int} that calls
     *      {@code this.call(l)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToInt bind(long l) {
        return LongToInt.bind(this, l);
    }

    /**
     * Allows {@code this} to act as a {@code LongToIntFunction}.
     *
     * @param l the argument
     * @return the result of the operation
     */
    @Override
    default int applyAsInt(long l) {
        return call(l);
    }
}
