package net.mintern.functions.unary;

/**
 * An operation of type {@code (long) -> void}.
 *
 */
@FunctionalInterface
public interface LongToNil extends
        net.mintern.functions.unary.checked.LongToNilE<RuntimeException>,
        java.util.function.LongConsumer {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.unary.checked.LongToNilE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> LongToNil unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.unary.checked.LongToNilE<E> f) {
        return (l) -> {
            try {
                f.call(l);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> LongToNil unchecked(
            net.mintern.functions.unary.checked.LongToNilE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> LongToNil uncheckedIO(
            net.mintern.functions.unary.checked.LongToNilE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (l)} to {@code f}, returning a new function
     * of type {@code () -> void}.
     *
     * @param f the unbound function
     * @param l the argument
     * @return a new function {@code () -> void} that calls
     *      {@code f.call(l)}.
     */
    static  net.mintern.functions.nullary.NilToNil
    bind(LongToNil f, long l) {
        return () -> f.call(l);
    }

    /**
     * Binds {@code (l)} to {@code this}, returning a new function
     * of type {@code () -> void}.
     *
     * @param l the argument
     * @return a new function {@code () -> void} that calls
     *      {@code this.call(l)}.
     */
    @Override
    default net.mintern.functions.nullary.NilToNil bind(long l) {
        return LongToNil.bind(this, l);
    }

    /**
     * Allows {@code this} to act as a {@code LongConsumer}.
     *
     * @param l the argument
     */
    @Override
    default void accept(long l) {
        call(l);
    }
}
