package net.mintern.functions.unary;

/**
 * An operation of type {@code (long) -> R}.
 *
 * @param <R> the type of the return value
 */
@FunctionalInterface
public interface LongToObj<R> extends
        net.mintern.functions.unary.checked.LongToObjE<R, RuntimeException>,
        java.util.function.LongFunction<R> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.unary.checked.LongToObjE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <R, E extends Exception> LongToObj<R> unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.unary.checked.LongToObjE<R, E> f) {
        return (l) -> {
            try {
                return f.call(l);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <R, E extends Exception> LongToObj<R> unchecked(
            net.mintern.functions.unary.checked.LongToObjE<R, E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <R, E extends java.io.IOException> LongToObj<R> uncheckedIO(
            net.mintern.functions.unary.checked.LongToObjE<R, E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (l)} to {@code f}, returning a new function
     * of type {@code () -> R}.
     *
     * @param <R> the type of the return value
     * @param f the unbound function
     * @param l the argument
     * @return a new function {@code () -> R} that calls
     *      {@code f.call(l)} and returns the result.
     */
    static <R> net.mintern.functions.nullary.NilToObj<R>
    bind(LongToObj<R> f, long l) {
        return () -> f.call(l);
    }

    /**
     * Binds {@code (l)} to {@code this}, returning a new function
     * of type {@code () -> R}.
     *
     * @param l the argument
     * @return a new function {@code () -> R} that calls
     *      {@code this.call(l)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToObj<R> bind(long l) {
        return LongToObj.bind(this, l);
    }

    /**
     * Allows {@code this} to act as a {@code LongFunction<R>}.
     *
     * @param l the argument
     * @return the result of the operation
     */
    @Override
    default R apply(long l) {
        return call(l);
    }
}
