package net.mintern.functions.unary;

/**
 * An operation of type {@code (T) -> long}.
 *
 * @param <T> the type of the argument
 */
@FunctionalInterface
public interface ObjToLong<T> extends
        net.mintern.functions.unary.checked.ObjToLongE<T, RuntimeException>,
        java.util.function.ToLongFunction<T> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.unary.checked.ObjToLongE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <T, E extends Exception> ObjToLong<T> unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.unary.checked.ObjToLongE<T, E> f) {
        return (t) -> {
            try {
                return f.call(t);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <T, E extends Exception> ObjToLong<T> unchecked(
            net.mintern.functions.unary.checked.ObjToLongE<T, E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <T, E extends java.io.IOException> ObjToLong<T> uncheckedIO(
            net.mintern.functions.unary.checked.ObjToLongE<T, E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (t)} to {@code f}, returning a new function
     * of type {@code () -> long}.
     *
     * @param <T> the type of the argument
     * @param f the unbound function
     * @param t the argument
     * @return a new function {@code () -> long} that calls
     *      {@code f.call(t)} and returns the result.
     */
    static <T> net.mintern.functions.nullary.NilToLong
    bind(ObjToLong<T> f, T t) {
        return () -> f.call(t);
    }

    /**
     * Binds {@code (t)} to {@code this}, returning a new function
     * of type {@code () -> long}.
     *
     * @param t the argument
     * @return a new function {@code () -> long} that calls
     *      {@code this.call(t)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToLong bind(T t) {
        return ObjToLong.bind(this, t);
    }

    /**
     * Allows {@code this} to act as a {@code ToLongFunction<T>}.
     *
     * @param t the argument
     * @return the result of the operation
     */
    @Override
    default long applyAsLong(T t) {
        return call(t);
    }
}
