package net.mintern.functions.unary;

/**
 * An operation of type {@code (T) -> R}.
 *
 * @param <T> the type of argument 1
 * @param <R> the type of the return value
 */
@FunctionalInterface
public interface ObjToObj<T, R> extends
        net.mintern.functions.unary.checked.ObjToObjE<T, R, RuntimeException>,
        java.util.function.Function<T, R> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <T> the type of argument 1
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.unary.checked.ObjToObjE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <T, R, E extends Exception> ObjToObj<T, R> unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.unary.checked.ObjToObjE<T, R, E> f) {
        return (t) -> {
            try {
                return f.call(t);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <T> the type of argument 1
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <T, R, E extends Exception> ObjToObj<T, R> unchecked(
            net.mintern.functions.unary.checked.ObjToObjE<T, R, E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <T> the type of argument 1
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <T, R, E extends java.io.IOException> ObjToObj<T, R> uncheckedIO(
            net.mintern.functions.unary.checked.ObjToObjE<T, R, E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (t)} to {@code f}, returning a new function
     * of type {@code () -> R}.
     *
     * @param <T> the type of argument 1
     * @param <R> the type of the return value
     * @param f the unbound function
     * @param t the argument
     * @return a new function {@code () -> R} that calls
     *      {@code f.call(t)} and returns the result.
     */
    static <T, R> net.mintern.functions.nullary.NilToObj<R>
    bind(ObjToObj<T, R> f, T t) {
        return () -> f.call(t);
    }

    /**
     * Binds {@code (t)} to {@code this}, returning a new function
     * of type {@code () -> R}.
     *
     * @param t the argument
     * @return a new function {@code () -> R} that calls
     *      {@code this.call(t)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToObj<R> bind(T t) {
        return ObjToObj.bind(this, t);
    }

    /**
     * Allows {@code this} to act as a {@code Function<T, R>}.
     *
     * @param t the argument
     * @return the result of the operation
     */
    @Override
    default R apply(T t) {
        return call(t);
    }
}
