package net.mintern.functions.unary.checked;

/**
 * An operation of type {@code (double) -> double}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface DblToDblE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param d the argument
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    double call(double d) throws E;

    /**
     * Binds {@code (d)} to {@code f}, returning a new function
     * of type {@code () -> double}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param d the argument
     * @return a new function {@code () -> double} that calls
     *      {@code f.call(d)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToDblE<E>
    bind(DblToDblE<E> f, double d) {
        return () -> f.call(d);
    }

    /**
     * Binds {@code (d)} to {@code this}, returning a new function
     * of type {@code () -> double}.
     *
     * @param d the argument
     * @return a new function {@code () -> double} that calls
     *      {@code this.call(d)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToDblE<E> bind(double d) {
        return DblToDblE.bind(this, d);
    }
}
