package net.mintern.functions.unary.checked;

/**
 * An operation of type {@code (double) -> long}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface DblToLongE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param d the argument
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    long call(double d) throws E;

    /**
     * Binds {@code (d)} to {@code f}, returning a new function
     * of type {@code () -> long}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param d the argument
     * @return a new function {@code () -> long} that calls
     *      {@code f.call(d)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToLongE<E>
    bind(DblToLongE<E> f, double d) {
        return () -> f.call(d);
    }

    /**
     * Binds {@code (d)} to {@code this}, returning a new function
     * of type {@code () -> long}.
     *
     * @param d the argument
     * @return a new function {@code () -> long} that calls
     *      {@code this.call(d)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToLongE<E> bind(double d) {
        return DblToLongE.bind(this, d);
    }
}
