package net.mintern.functions.unary.checked;

/**
 * An operation of type {@code (double) -> void}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface DblToNilE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param d the argument
     * @throws E if the operation cannot be completed
     */
    void call(double d) throws E;

    /**
     * Binds {@code (d)} to {@code f}, returning a new function
     * of type {@code () -> void}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param d the argument
     * @return a new function {@code () -> void} that calls
     *      {@code f.call(d)}.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToNilE<E>
    bind(DblToNilE<E> f, double d) {
        return () -> f.call(d);
    }

    /**
     * Binds {@code (d)} to {@code this}, returning a new function
     * of type {@code () -> void}.
     *
     * @param d the argument
     * @return a new function {@code () -> void} that calls
     *      {@code this.call(d)}.
     */
    default net.mintern.functions.nullary.checked.NilToNilE<E> bind(double d) {
        return DblToNilE.bind(this, d);
    }
}
