package net.mintern.functions.unary.checked;

/**
 * An operation of type {@code (double) -> R}.
 *
 * @param <R> the type of the return value
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface DblToObjE<R, E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param d the argument
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    R call(double d) throws E;

    /**
     * Binds {@code (d)} to {@code f}, returning a new function
     * of type {@code () -> R}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param d the argument
     * @return a new function {@code () -> R} that calls
     *      {@code f.call(d)} and returns the result.
     */
    @SuppressWarnings("unchecked") // maven spuriously warns about a type error in this case
    static <R, E extends Exception> net.mintern.functions.nullary.checked.NilToObjE<R, E>
    bind(DblToObjE<R, E> f, double d) {
        return () -> f.call(d);
    }

    /**
     * Binds {@code (d)} to {@code this}, returning a new function
     * of type {@code () -> R}.
     *
     * @param d the argument
     * @return a new function {@code () -> R} that calls
     *      {@code this.call(d)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToObjE<R, E> bind(double d) {
        return DblToObjE.bind(this, d);
    }
}
