package net.mintern.functions.unary.checked;

/**
 * An operation of type {@code (int) -> double}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface IntToDblE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param i the argument
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    double call(int i) throws E;

    /**
     * Binds {@code (i)} to {@code f}, returning a new function
     * of type {@code () -> double}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param i the argument
     * @return a new function {@code () -> double} that calls
     *      {@code f.call(i)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToDblE<E>
    bind(IntToDblE<E> f, int i) {
        return () -> f.call(i);
    }

    /**
     * Binds {@code (i)} to {@code this}, returning a new function
     * of type {@code () -> double}.
     *
     * @param i the argument
     * @return a new function {@code () -> double} that calls
     *      {@code this.call(i)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToDblE<E> bind(int i) {
        return IntToDblE.bind(this, i);
    }
}
