package net.mintern.functions.unary.checked;

/**
 * An operation of type {@code (int) -> void}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface IntToNilE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param i the argument
     * @throws E if the operation cannot be completed
     */
    void call(int i) throws E;

    /**
     * Binds {@code (i)} to {@code f}, returning a new function
     * of type {@code () -> void}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param i the argument
     * @return a new function {@code () -> void} that calls
     *      {@code f.call(i)}.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToNilE<E>
    bind(IntToNilE<E> f, int i) {
        return () -> f.call(i);
    }

    /**
     * Binds {@code (i)} to {@code this}, returning a new function
     * of type {@code () -> void}.
     *
     * @param i the argument
     * @return a new function {@code () -> void} that calls
     *      {@code this.call(i)}.
     */
    default net.mintern.functions.nullary.checked.NilToNilE<E> bind(int i) {
        return IntToNilE.bind(this, i);
    }
}
