package net.mintern.functions.unary.checked;

/**
 * An operation of type {@code (int) -> R}.
 *
 * @param <R> the type of the return value
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface IntToObjE<R, E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param i the argument
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    R call(int i) throws E;

    /**
     * Binds {@code (i)} to {@code f}, returning a new function
     * of type {@code () -> R}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param i the argument
     * @return a new function {@code () -> R} that calls
     *      {@code f.call(i)} and returns the result.
     */
    @SuppressWarnings("unchecked") // maven spuriously warns about a type error in this case
    static <R, E extends Exception> net.mintern.functions.nullary.checked.NilToObjE<R, E>
    bind(IntToObjE<R, E> f, int i) {
        return () -> f.call(i);
    }

    /**
     * Binds {@code (i)} to {@code this}, returning a new function
     * of type {@code () -> R}.
     *
     * @param i the argument
     * @return a new function {@code () -> R} that calls
     *      {@code this.call(i)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToObjE<R, E> bind(int i) {
        return IntToObjE.bind(this, i);
    }
}
