package net.mintern.functions.unary.checked;

/**
 * An operation of type {@code (long) -> boolean}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface LongToBoolE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param l the argument
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    boolean call(long l) throws E;

    /**
     * Binds {@code (l)} to {@code f}, returning a new function
     * of type {@code () -> boolean}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param l the argument
     * @return a new function {@code () -> boolean} that calls
     *      {@code f.call(l)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToBoolE<E>
    bind(LongToBoolE<E> f, long l) {
        return () -> f.call(l);
    }

    /**
     * Binds {@code (l)} to {@code this}, returning a new function
     * of type {@code () -> boolean}.
     *
     * @param l the argument
     * @return a new function {@code () -> boolean} that calls
     *      {@code this.call(l)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToBoolE<E> bind(long l) {
        return LongToBoolE.bind(this, l);
    }
}
