package net.mintern.functions.unary.checked;

/**
 * An operation of type {@code (long) -> double}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface LongToDblE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param l the argument
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    double call(long l) throws E;

    /**
     * Binds {@code (l)} to {@code f}, returning a new function
     * of type {@code () -> double}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param l the argument
     * @return a new function {@code () -> double} that calls
     *      {@code f.call(l)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToDblE<E>
    bind(LongToDblE<E> f, long l) {
        return () -> f.call(l);
    }

    /**
     * Binds {@code (l)} to {@code this}, returning a new function
     * of type {@code () -> double}.
     *
     * @param l the argument
     * @return a new function {@code () -> double} that calls
     *      {@code this.call(l)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToDblE<E> bind(long l) {
        return LongToDblE.bind(this, l);
    }
}
