package net.mintern.functions.unary.checked;

/**
 * An operation of type {@code (long) -> int}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface LongToIntE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param l the argument
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    int call(long l) throws E;

    /**
     * Binds {@code (l)} to {@code f}, returning a new function
     * of type {@code () -> int}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param l the argument
     * @return a new function {@code () -> int} that calls
     *      {@code f.call(l)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToIntE<E>
    bind(LongToIntE<E> f, long l) {
        return () -> f.call(l);
    }

    /**
     * Binds {@code (l)} to {@code this}, returning a new function
     * of type {@code () -> int}.
     *
     * @param l the argument
     * @return a new function {@code () -> int} that calls
     *      {@code this.call(l)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToIntE<E> bind(long l) {
        return LongToIntE.bind(this, l);
    }
}
