package net.mintern.functions.unary.checked;

/**
 * An operation of type {@code (long) -> long}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface LongToLongE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param l the argument
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    long call(long l) throws E;

    /**
     * Binds {@code (l)} to {@code f}, returning a new function
     * of type {@code () -> long}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param l the argument
     * @return a new function {@code () -> long} that calls
     *      {@code f.call(l)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToLongE<E>
    bind(LongToLongE<E> f, long l) {
        return () -> f.call(l);
    }

    /**
     * Binds {@code (l)} to {@code this}, returning a new function
     * of type {@code () -> long}.
     *
     * @param l the argument
     * @return a new function {@code () -> long} that calls
     *      {@code this.call(l)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToLongE<E> bind(long l) {
        return LongToLongE.bind(this, l);
    }
}
