package net.mintern.functions.unary.checked;

/**
 * An operation of type {@code (long) -> void}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface LongToNilE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param l the argument
     * @throws E if the operation cannot be completed
     */
    void call(long l) throws E;

    /**
     * Binds {@code (l)} to {@code f}, returning a new function
     * of type {@code () -> void}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param l the argument
     * @return a new function {@code () -> void} that calls
     *      {@code f.call(l)}.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToNilE<E>
    bind(LongToNilE<E> f, long l) {
        return () -> f.call(l);
    }

    /**
     * Binds {@code (l)} to {@code this}, returning a new function
     * of type {@code () -> void}.
     *
     * @param l the argument
     * @return a new function {@code () -> void} that calls
     *      {@code this.call(l)}.
     */
    default net.mintern.functions.nullary.checked.NilToNilE<E> bind(long l) {
        return LongToNilE.bind(this, l);
    }
}
