package net.mintern.functions.unary.checked;

/**
 * An operation of type {@code (long) -> R}.
 *
 * @param <R> the type of the return value
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface LongToObjE<R, E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param l the argument
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    R call(long l) throws E;

    /**
     * Binds {@code (l)} to {@code f}, returning a new function
     * of type {@code () -> R}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param l the argument
     * @return a new function {@code () -> R} that calls
     *      {@code f.call(l)} and returns the result.
     */
    @SuppressWarnings("unchecked") // maven spuriously warns about a type error in this case
    static <R, E extends Exception> net.mintern.functions.nullary.checked.NilToObjE<R, E>
    bind(LongToObjE<R, E> f, long l) {
        return () -> f.call(l);
    }

    /**
     * Binds {@code (l)} to {@code this}, returning a new function
     * of type {@code () -> R}.
     *
     * @param l the argument
     * @return a new function {@code () -> R} that calls
     *      {@code this.call(l)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToObjE<R, E> bind(long l) {
        return LongToObjE.bind(this, l);
    }
}
