package net.mintern.functions.unary.checked;

/**
 * An operation of type {@code (T) -> double}.
 *
 * @param <T> the type of argument 1
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ObjToDblE<T, E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param t the argument
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    double call(T t) throws E;

    /**
     * Binds {@code (t)} to {@code f}, returning a new function
     * of type {@code () -> double}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param t the argument
     * @return a new function {@code () -> double} that calls
     *      {@code f.call(t)} and returns the result.
     */
    static <T, E extends Exception> net.mintern.functions.nullary.checked.NilToDblE<E>
    bind(ObjToDblE<T, E> f, T t) {
        return () -> f.call(t);
    }

    /**
     * Binds {@code (t)} to {@code this}, returning a new function
     * of type {@code () -> double}.
     *
     * @param t the argument
     * @return a new function {@code () -> double} that calls
     *      {@code this.call(t)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToDblE<E> bind(T t) {
        return ObjToDblE.bind(this, t);
    }
}
