package net.mintern.functions.unary.checked;

/**
 * An operation of type {@code (T) -> int}.
 *
 * @param <T> the type of argument 1
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ObjToIntE<T, E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param t the argument
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    int call(T t) throws E;

    /**
     * Binds {@code (t)} to {@code f}, returning a new function
     * of type {@code () -> int}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param t the argument
     * @return a new function {@code () -> int} that calls
     *      {@code f.call(t)} and returns the result.
     */
    static <T, E extends Exception> net.mintern.functions.nullary.checked.NilToIntE<E>
    bind(ObjToIntE<T, E> f, T t) {
        return () -> f.call(t);
    }

    /**
     * Binds {@code (t)} to {@code this}, returning a new function
     * of type {@code () -> int}.
     *
     * @param t the argument
     * @return a new function {@code () -> int} that calls
     *      {@code this.call(t)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToIntE<E> bind(T t) {
        return ObjToIntE.bind(this, t);
    }
}
