package net.mintern.functions.unary.checked;

/**
 * An operation of type {@code (T) -> long}.
 *
 * @param <T> the type of argument 1
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ObjToLongE<T, E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param t the argument
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    long call(T t) throws E;

    /**
     * Binds {@code (t)} to {@code f}, returning a new function
     * of type {@code () -> long}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param t the argument
     * @return a new function {@code () -> long} that calls
     *      {@code f.call(t)} and returns the result.
     */
    static <T, E extends Exception> net.mintern.functions.nullary.checked.NilToLongE<E>
    bind(ObjToLongE<T, E> f, T t) {
        return () -> f.call(t);
    }

    /**
     * Binds {@code (t)} to {@code this}, returning a new function
     * of type {@code () -> long}.
     *
     * @param t the argument
     * @return a new function {@code () -> long} that calls
     *      {@code this.call(t)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToLongE<E> bind(T t) {
        return ObjToLongE.bind(this, t);
    }
}
