package net.mintern.functions.unary.checked;

/**
 * An operation of type {@code (T) -> void}.
 *
 * @param <T> the type of argument 1
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ObjToNilE<T, E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param t the argument
     * @throws E if the operation cannot be completed
     */
    void call(T t) throws E;

    /**
     * Binds {@code (t)} to {@code f}, returning a new function
     * of type {@code () -> void}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param t the argument
     * @return a new function {@code () -> void} that calls
     *      {@code f.call(t)}.
     */
    static <T, E extends Exception> net.mintern.functions.nullary.checked.NilToNilE<E>
    bind(ObjToNilE<T, E> f, T t) {
        return () -> f.call(t);
    }

    /**
     * Binds {@code (t)} to {@code this}, returning a new function
     * of type {@code () -> void}.
     *
     * @param t the argument
     * @return a new function {@code () -> void} that calls
     *      {@code this.call(t)}.
     */
    default net.mintern.functions.nullary.checked.NilToNilE<E> bind(T t) {
        return ObjToNilE.bind(this, t);
    }
}
