package net.mintern.functions.unary.checked;

/**
 * An operation of type {@code (T) -> R}.
 *
 * @param <T> the type of argument 1
 * @param <R> the type of the return value
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ObjToObjE<T, R, E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param t the argument
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    R call(T t) throws E;

    /**
     * Binds {@code (t)} to {@code f}, returning a new function
     * of type {@code () -> R}.
     *
     * @param <T> the type of argument 1
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param t the argument
     * @return a new function {@code () -> R} that calls
     *      {@code f.call(t)} and returns the result.
     */
    @SuppressWarnings("unchecked") // maven spuriously warns about a type error in this case
    static <T, R, E extends Exception> net.mintern.functions.nullary.checked.NilToObjE<R, E>
    bind(ObjToObjE<T, R, E> f, T t) {
        return () -> f.call(t);
    }

    /**
     * Binds {@code (t)} to {@code this}, returning a new function
     * of type {@code () -> R}.
     *
     * @param t the argument
     * @return a new function {@code () -> R} that calls
     *      {@code this.call(t)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToObjE<R, E> bind(T t) {
        return ObjToObjE.bind(this, t);
    }
}
