/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Parcel;
import android.os.ParcelFormatException;
import android.os.PersistableBundle;
import android.util.Pair;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class BaseBundle {
    protected final Map<String, Pair<Type, Object>> map;

    public void clear() {
        this.map.clear();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    public Set<String> keySet() {
        return this.map.keySet();
    }

    public void putAll(PersistableBundle bundle) {
        this.map.putAll(bundle.map);
    }

    public void remove(String key) {
        this.map.remove(key);
    }

    public int size() {
        return this.map.size();
    }

    public Object get(String key) {
        Pair<Type, Object> entry = this.map.get(key);
        if (entry != null) {
            return entry.second;
        }
        return null;
    }

    boolean getBoolean(String key, boolean defaultValue) {
        return this.get(key, Type.BOOLEAN, defaultValue);
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public void putBoolean(String key, boolean value) {
        this.put(key, Type.BOOLEAN, value);
    }

    public boolean[] getBooleanArray(String key) {
        return this.get(key, Type.BOOLEAN_ARRAY, null);
    }

    public void putBooleanArray(String key, boolean[] array) {
        this.put(key, Type.BOOLEAN_ARRAY, array);
    }

    public double getDouble(String key, double defaultValue) {
        return this.get(key, Type.DOUBLE, defaultValue);
    }

    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    public void putDouble(String key, double value) {
        this.put(key, Type.DOUBLE, value);
    }

    public double[] getDoubleArray(String key) {
        return this.get(key, Type.DOUBLE_ARRAY, null);
    }

    public void putDoubleArray(String key, double[] array) {
        this.put(key, Type.DOUBLE_ARRAY, array);
    }

    public int getInt(String key, int defaultValue) {
        return this.get(key, Type.INT, defaultValue);
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public void putInt(String key, int value) {
        this.put(key, Type.INT, value);
    }

    public int[] getIntArray(String key) {
        return this.get(key, Type.INT_ARRAY, null);
    }

    public void putIntArray(String key, int[] array) {
        this.put(key, Type.INT_ARRAY, array);
    }

    public long getLong(String key, long defaultValue) {
        return this.get(key, Type.LONG, defaultValue);
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public void putLong(String key, long value) {
        this.put(key, Type.LONG, value);
    }

    public long[] getLongArray(String key) {
        return this.get(key, Type.LONG_ARRAY, null);
    }

    public void putLongArray(String key, long[] array) {
        this.put(key, Type.LONG_ARRAY, array);
    }

    public String getString(String key, String defaultValue) {
        return this.get(key, Type.STRING, defaultValue);
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public void putString(String key, String value) {
        this.put(key, Type.STRING, value);
    }

    public String[] getStringArray(String key) {
        return this.get(key, Type.STRING_ARRAY, null);
    }

    public void putStringArray(String key, String[] array) {
        this.put(key, Type.STRING_ARRAY, array);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        BaseBundle other = (BaseBundle)o;
        if (!this.keySet().equals(other.keySet())) {
            return false;
        }
        block11: for (String key : this.keySet()) {
            Pair<Type, Object> a = this.map.get(key);
            Pair<Type, Object> b = other.map.get(key);
            if (!((Type)((Object)a.first)).equals(b.first)) {
                return false;
            }
            switch ((Type)((Object)a.first)) {
                case BOOLEAN_ARRAY: {
                    if (Arrays.equals((boolean[])a.second, (boolean[])b.second)) continue block11;
                    return false;
                }
                case BYTE_ARRAY: {
                    if (Arrays.equals((byte[])a.second, (byte[])b.second)) continue block11;
                    return false;
                }
                case SHORT_ARRAY: {
                    if (Arrays.equals((short[])a.second, (short[])b.second)) continue block11;
                    return false;
                }
                case INT_ARRAY: {
                    if (Arrays.equals((int[])a.second, (int[])b.second)) continue block11;
                    return false;
                }
                case LONG_ARRAY: {
                    if (Arrays.equals((long[])a.second, (long[])b.second)) continue block11;
                    return false;
                }
                case FLOAT_ARRAY: {
                    if (Arrays.equals((float[])a.second, (float[])b.second)) continue block11;
                    return false;
                }
                case DOUBLE_ARRAY: {
                    if (Arrays.equals((double[])a.second, (double[])b.second)) continue block11;
                    return false;
                }
                case CHAR_ARRAY: {
                    if (Arrays.equals((char[])a.second, (char[])b.second)) continue block11;
                    return false;
                }
                case STRING_ARRAY: 
                case CHAR_SEQUENCE_ARRAY: 
                case PARCELABLE_ARRAY: {
                    if (Arrays.equals((Object[])a.second, (Object[])b.second)) continue block11;
                    return false;
                }
            }
            if (Objects.equals(a.second, b.second)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     */
    public String toString() {
        Map<String, Pair<Type, Object>> map = this.map;
        synchronized (map) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName()).append('(');
            boolean first = true;
            block16: for (Map.Entry<String, Pair<Type, Object>> entry : this.map.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    builder.append(',');
                }
                builder.append(entry.getKey()).append("=");
                switch ((Type)((Object)entry.getValue().first)) {
                    case BOOLEAN_ARRAY: {
                        builder.append(Arrays.toString((boolean[])entry.getValue().second).replaceAll(" ", ""));
                        continue block16;
                    }
                    case BYTE_ARRAY: {
                        builder.append(Arrays.toString((byte[])entry.getValue().second).replaceAll(" ", ""));
                        continue block16;
                    }
                    case SHORT_ARRAY: {
                        builder.append(Arrays.toString((short[])entry.getValue().second).replaceAll(" ", ""));
                        continue block16;
                    }
                    case INT_ARRAY: {
                        builder.append(Arrays.toString((int[])entry.getValue().second).replaceAll(" ", ""));
                        continue block16;
                    }
                    case LONG_ARRAY: {
                        builder.append(Arrays.toString((long[])entry.getValue().second).replaceAll(" ", ""));
                        continue block16;
                    }
                    case FLOAT_ARRAY: {
                        builder.append(Arrays.toString((float[])entry.getValue().second).replaceAll(" ", ""));
                        continue block16;
                    }
                    case DOUBLE_ARRAY: {
                        builder.append(Arrays.toString((double[])entry.getValue().second).replaceAll(" ", ""));
                        continue block16;
                    }
                    case STRING_ARRAY: 
                    case CHAR_SEQUENCE_ARRAY: {
                        CharSequence[] o = (CharSequence[])entry.getValue().second;
                        if (o == null) {
                            builder.append("null");
                            continue block16;
                        }
                        builder.append('[');
                        boolean cs_first = true;
                        for (CharSequence cs : o) {
                            if (cs_first) {
                                cs_first = false;
                            } else {
                                builder.append(',');
                            }
                            builder.append('\"').append(Objects.toString(cs)).append('\"');
                        }
                        builder.append(']');
                        continue block16;
                    }
                    case PARCELABLE_ARRAY: {
                        Object[] arr = (Object[])entry.getValue().second;
                        if (arr == null) {
                            builder.append("null");
                            continue block16;
                        }
                        builder.append('[');
                        boolean cs_first = true;
                        for (Object p : arr) {
                            if (cs_first) {
                                cs_first = false;
                            } else {
                                builder.append(',');
                            }
                            builder.append(Objects.toString(p));
                        }
                        builder.append(']');
                        continue block16;
                    }
                    case INT_ARRAY_LIST: {
                        Object[] arr = (Object[])entry.getValue().second;
                        if (arr == null) {
                            builder.append("null");
                            continue block16;
                        }
                        builder.append('[');
                        boolean cs_first = true;
                        for (Integer it : arr) {
                            if (cs_first) {
                                cs_first = false;
                            } else {
                                builder.append(',');
                            }
                            builder.append(Integer.toString(it));
                        }
                        builder.append(']');
                        continue block16;
                    }
                    case PARCELABLE_ARRAY_LIST: {
                        builder.append(Objects.toString(entry.getValue().second).replaceAll(" ", ""));
                        continue block16;
                    }
                }
                builder.append(Objects.toString(entry.getValue().second));
            }
            builder.append(')');
            return builder.toString();
        }
    }

    protected BaseBundle(Map<String, Pair<Type, Object>> map) {
        this.map = Collections.synchronizedMap(map);
    }

    protected BaseBundle(int capacity) {
        this(capacity > 0 ? new HashMap<String, Pair<Type, Object>>(capacity) : new HashMap());
    }

    protected <T> T get(String key, Type type, T defaultValue) {
        Pair<Type, Object> val = this.map.get(key);
        if (val != null && type.equals(val.first)) {
            return (T)val.second;
        }
        return defaultValue;
    }

    protected void put(String key, Type type, Object entry) {
        this.map.put(key, Pair.create(type, entry));
    }

    protected boolean writeToParcel(Parcel dest, String key, Type type, Object value) {
        dest.writeString(key);
        dest.writeInt(type.ordinal());
        if (value == null) {
            dest.writeByte((byte)0);
            return true;
        }
        dest.writeByte((byte)1);
        switch (type) {
            case BOOLEAN: {
                dest.writeByte((byte)((Boolean)value != false ? 1 : 0));
                return true;
            }
            case BOOLEAN_ARRAY: {
                dest.writeBooleanArray((boolean[])value);
                return true;
            }
            case DOUBLE: {
                dest.writeDouble((Double)value);
                return true;
            }
            case DOUBLE_ARRAY: {
                dest.writeDoubleArray((double[])value);
                return true;
            }
            case INT: {
                dest.writeInt((Integer)value);
                return true;
            }
            case INT_ARRAY: {
                dest.writeIntArray((int[])value);
                return true;
            }
            case LONG: {
                dest.writeLong((Long)value);
                return true;
            }
            case LONG_ARRAY: {
                dest.writeLongArray((long[])value);
                return true;
            }
            case STRING: {
                dest.writeString((String)value);
                return true;
            }
            case STRING_ARRAY: {
                dest.writeStringArray((String[])value);
                return true;
            }
        }
        return false;
    }

    protected boolean readFromParcel(Parcel source, String key, Type type) {
        if (Type.UNKNOWN.equals((Object)type)) {
            throw new ParcelFormatException("Unknown value type.");
        }
        if (source.readByte() == 0) {
            this.put(key, type, null);
            return true;
        }
        switch (type) {
            case BOOLEAN: {
                this.putBoolean(key, source.readByte() != 0);
                return true;
            }
            case BOOLEAN_ARRAY: {
                this.putBooleanArray(key, source.createBooleanArray());
                return true;
            }
            case DOUBLE: {
                this.putDouble(key, source.readDouble());
                return true;
            }
            case DOUBLE_ARRAY: {
                this.putDoubleArray(key, source.createDoubleArray());
                return true;
            }
            case INT: {
                this.putInt(key, source.readInt());
                return true;
            }
            case INT_ARRAY: {
                this.putIntArray(key, source.createIntArray());
                return true;
            }
            case LONG: {
                this.putLong(key, source.readLong());
                return true;
            }
            case LONG_ARRAY: {
                this.putLongArray(key, source.createLongArray());
                return true;
            }
            case STRING: {
                this.putString(key, source.readString());
                return true;
            }
            case STRING_ARRAY: {
                this.putStringArray(key, source.createStringArray());
                return true;
            }
        }
        return false;
    }

    protected static enum Type {
        UNKNOWN,
        BOOLEAN,
        BOOLEAN_ARRAY,
        DOUBLE,
        DOUBLE_ARRAY,
        INT,
        INT_ARRAY,
        LONG,
        LONG_ARRAY,
        STRING,
        STRING_ARRAY,
        PERSISTABLE_BUNDLE,
        BUNDLE,
        BYTE,
        BYTE_ARRAY,
        CHAR,
        CHAR_ARRAY,
        CHAR_SEQUENCE,
        CHAR_SEQUENCE_ARRAY,
        FLOAT,
        FLOAT_ARRAY,
        INT_ARRAY_LIST,
        PARCELABLE,
        PARCELABLE_ARRAY,
        PARCELABLE_ARRAY_LIST,
        SERIALIZABLE,
        SHORT,
        SHORT_ARRAY,
        STRING_ARRAY_LIST,
        SIZE,
        SIZE_F,
        BINDER,
        SPARSE_PARCELABLE_ARRAY;


        public static Type valueOf(int ordinal) {
            for (Type type : Type.values()) {
                if (type.ordinal() != ordinal) continue;
                return type;
            }
            return UNKNOWN;
        }
    }
}

