/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.BadParcelableException;
import android.os.ParcelFormatException;
import android.os.Parcelable;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;

public final class Parcel {
    public static final Parcelable.Creator<String> STRING_CREATOR = new Parcelable.Creator<String>(){

        @Override
        public String createFromParcel(Parcel source) {
            return source.readString();
        }

        public String[] newArray(int size) {
            return new String[size];
        }
    };
    private byte[] buffer = new byte[1024];
    private int size = 0;
    private int position = 0;
    private static final int kCapacityStep = 1024;
    private static final int kMaxPoolSize = 10;
    private static final Queue<Parcel> pool = new ArrayDeque<Parcel>(10);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Parcel obtain() {
        Queue<Parcel> queue = pool;
        synchronized (queue) {
            if (pool.size() > 0) {
                return pool.poll();
            }
        }
        return new Parcel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() {
        this.size = 0;
        this.position = 0;
        Arrays.fill(this.buffer, 0, this.buffer.length, (byte)0);
        Queue<Parcel> queue = pool;
        synchronized (queue) {
            if (pool.size() == 10) {
                pool.poll();
            }
            pool.offer(this);
        }
    }

    public void appendFrom(Parcel parcel, int offset, int length) {
        this.append(parcel.buffer, offset, length);
    }

    public int dataAvail() {
        return this.size - this.position;
    }

    public int dataCapacity() {
        return this.buffer.length;
    }

    public int dataPosition() {
        return this.position;
    }

    public int dataSize() {
        return this.size;
    }

    public void setDataCapacity(int capacity) {
        if (capacity < this.size) {
            throw new IllegalArgumentException("New capacity " + capacity + " is smaller than current data size: " + this.size);
        }
        byte[] tmp = new byte[capacity];
        System.arraycopy(this.buffer, 0, tmp, 0, this.size);
        this.buffer = tmp;
    }

    public void setDataPosition(int pos) {
        if (pos > this.size) {
            throw new IllegalArgumentException("New position is after last known byte.");
        }
        this.position = pos;
    }

    public void setDataSize(int newSize) {
        if (newSize == this.size) {
            return;
        }
        if (newSize < this.size) {
            this.trim(newSize);
        } else {
            this.grow(newSize);
        }
    }

    public byte[] marshall() {
        byte[] result = new byte[this.size];
        System.arraycopy(this.buffer, 0, result, 0, this.size);
        return result;
    }

    public void unmarshall(byte[] data, int offset, int length) {
        this.size = 0;
        this.position = 0;
        this.append(data, offset, length);
    }

    public void writeByte(byte b) {
        this.ensureCapacity(this.size + 1);
        this.size += Parcel.encode(b, this.buffer, this.size);
    }

    public byte readByte() {
        this.ensureAvailable(1);
        byte tmp = this.buffer[this.position];
        ++this.position;
        return tmp;
    }

    public void writeDouble(double d) {
        this.ensureCapacity(this.size + 8);
        long value = Double.doubleToLongBits(d);
        this.size += Parcel.encode(value, this.buffer, this.size);
    }

    public double readDouble() {
        this.ensureAvailable(8);
        long value = Parcel.decode(this.buffer, this.position, 8);
        this.position += 8;
        return Double.longBitsToDouble(value);
    }

    public void writeFloat(float f) {
        this.ensureCapacity(this.size + 4);
        int value = Float.floatToIntBits(f);
        this.size += Parcel.encode(value, this.buffer, this.size);
    }

    public float readFloat() {
        this.ensureAvailable(4);
        int value = (int)Parcel.decode(this.buffer, this.position, 4);
        this.position += 4;
        return Float.intBitsToFloat(value);
    }

    public void writeInt(int i) {
        this.ensureCapacity(this.size + 4);
        this.size += Parcel.encode(i, this.buffer, this.size);
    }

    public int readInt() {
        this.ensureAvailable(4);
        int value = (int)Parcel.decode(this.buffer, this.position, 4);
        this.position += 4;
        return value;
    }

    public void writeLong(long l) {
        this.ensureCapacity(this.size + 8);
        this.size += Parcel.encode(l, this.buffer, this.size);
    }

    public long readLong() {
        this.ensureAvailable(8);
        long value = Parcel.decode(this.buffer, this.position, 8);
        this.position += 8;
        return value;
    }

    public void writeString(String s) {
        if (s != null) {
            byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
            this.ensureCapacity(this.size + 4 + bytes.length);
            this.size += Parcel.encode(bytes.length, this.buffer, this.size);
            System.arraycopy(bytes, 0, this.buffer, this.size, bytes.length);
            this.size += bytes.length;
        } else {
            this.writeInt(-1);
        }
    }

    public String readString() {
        int len = this.readInt();
        if (len < 0) {
            return null;
        }
        this.ensureAvailable(len);
        String out = new String(this.buffer, this.position, len, StandardCharsets.UTF_8);
        this.position += len;
        return out;
    }

    public void writeBooleanArray(boolean[] arr) {
        byte[] bytes = Parcel.packBits(arr);
        this.ensureCapacity(4 + bytes.length);
        Parcel.encode(arr.length, this.buffer, this.size);
        this.size += 4;
        System.arraycopy(bytes, 0, this.buffer, this.size, bytes.length);
        this.size += bytes.length;
    }

    public void readBooleanArray(boolean[] dest) {
        boolean[] arr = this.createBooleanArray();
        System.arraycopy(arr, 0, dest, 0, Math.min(dest.length, arr.length));
    }

    public boolean[] createBooleanArray() {
        int len = this.readInt();
        byte[] tmp = new byte[Parcel.booleanArraySizeToBytes(len)];
        System.arraycopy(this.buffer, this.position, tmp, 0, tmp.length);
        this.position += tmp.length;
        return Parcel.unpackBits(tmp, len);
    }

    public void writeByteArray(byte[] arr) {
        this.writeByteArray(arr, 0, arr.length);
    }

    public void writeByteArray(byte[] arr, int offset, int len) {
        this.ensureCapacity(this.size + 4 + len);
        this.size += Parcel.encode(len, this.buffer, this.size);
        System.arraycopy(arr, offset, this.buffer, this.size, len);
        this.size += len;
    }

    public void readByteArray(byte[] dest) {
        int len = this.readInt();
        int copyLen = Math.min(dest.length, len);
        this.position += 4;
        this.ensureAvailable(len);
        System.arraycopy(this.buffer, this.position, dest, 0, copyLen);
        this.position += len;
    }

    public byte[] createByteArray() {
        int len = this.readInt();
        this.ensureAvailable(len);
        byte[] out = new byte[len];
        System.arraycopy(this.buffer, this.position, out, 0, len);
        this.position += len;
        return out;
    }

    public void writeCharArray(char[] arr) {
        this.writeByteArray(this.chars2bytes(arr));
    }

    public void readCharArray(char[] dest) {
        char[] out = this.createCharArray();
        System.arraycopy(out, 0, dest, 0, Math.min(out.length, dest.length));
    }

    public char[] createCharArray() {
        return this.bytes2chars(this.createByteArray());
    }

    public void writeDoubleArray(double[] arr) {
        this.ensureCapacity(4 + 8 * arr.length);
        this.writeInt(arr.length);
        for (double d : arr) {
            this.writeDouble(d);
        }
    }

    public void readDoubleArray(double[] dest) {
        double[] out = this.createDoubleArray();
        System.arraycopy(out, 0, dest, 0, Math.min(dest.length, out.length));
    }

    public double[] createDoubleArray() {
        int len = this.readInt();
        double[] out = new double[len];
        for (int i = 0; i < len; ++i) {
            out[i] = this.readDouble();
        }
        return out;
    }

    public void writeFloatArray(float[] arr) {
        this.ensureCapacity(4 + 4 * arr.length);
        this.writeInt(arr.length);
        for (float f : arr) {
            this.writeFloat(f);
        }
    }

    public void readFloatArray(float[] dest) {
        float[] out = this.createFloatArray();
        System.arraycopy(out, 0, dest, 0, Math.min(dest.length, out.length));
    }

    public float[] createFloatArray() {
        int len = this.readInt();
        float[] out = new float[len];
        for (int i = 0; i < len; ++i) {
            out[i] = this.readFloat();
        }
        return out;
    }

    public void writeIntArray(int[] arr) {
        this.ensureCapacity(4 + 4 * arr.length);
        this.writeInt(arr.length);
        for (int i : arr) {
            this.writeInt(i);
        }
    }

    public void readIntArray(int[] dest) {
        int[] out = this.createIntArray();
        System.arraycopy(out, 0, dest, 0, Math.min(dest.length, out.length));
    }

    public int[] createIntArray() {
        int len = this.readInt();
        int[] out = new int[len];
        for (int i = 0; i < len; ++i) {
            out[i] = this.readInt();
        }
        return out;
    }

    public void writeLongArray(long[] arr) {
        this.ensureCapacity(4 + 8 * arr.length);
        this.writeInt(arr.length);
        for (long l : arr) {
            this.writeLong(l);
        }
    }

    public void readLongArray(long[] dest) {
        long[] out = this.createLongArray();
        System.arraycopy(out, 0, dest, 0, Math.min(dest.length, out.length));
    }

    public long[] createLongArray() {
        int len = this.readInt();
        long[] out = new long[len];
        for (int i = 0; i < len; ++i) {
            out[i] = this.readLong();
        }
        return out;
    }

    public void writeStringArray(String[] arr) {
        this.writeInt(arr.length);
        for (String s : arr) {
            this.writeString(s);
        }
    }

    public void readStringArray(String[] dest) {
        int len = this.readInt();
        for (int i = 0; i < len; ++i) {
            String tmp = this.readString();
            if (i >= dest.length) continue;
            dest[i] = tmp;
        }
    }

    public String[] createStringArray() {
        int len = this.readInt();
        String[] out = new String[len];
        for (int i = 0; i < len; ++i) {
            out[i] = this.readString();
        }
        return out;
    }

    public void writeParcelable(Parcelable p, int flags) {
        this.writeCreator(p.getClass());
        p.writeToParcel(this, flags);
    }

    public <T extends Parcelable> T readParcelable(ClassLoader loader) {
        Parcelable.Creator<T> creator = this.readCreator(loader);
        return (T)((Parcelable)creator.createFromParcel(this));
    }

    public <T extends Parcelable> void writeParcelableArray(T[] arr, int flags) {
        this.writeCreator(arr.getClass().getComponentType());
        this.writeTypedArray((Parcelable[])arr, flags);
    }

    public <T extends Parcelable> T[] readParcelableArray(ClassLoader loader) {
        Parcelable.Creator<T> creator = this.readCreator(loader);
        return this.createTypedArray(creator);
    }

    public <T extends Parcelable> void writeTypedObject(T source, int flags) {
        source.writeToParcel(this, flags);
    }

    public <T extends Parcelable> T readTypedObject(Parcelable.Creator<T> creator) {
        return (T)((Parcelable)creator.createFromParcel(this));
    }

    public <T extends Parcelable> void writeTypedArray(T[] arr, int flags) {
        this.writeInt(arr.length);
        for (T t : arr) {
            this.writeTypedObject(t, flags);
        }
    }

    public <T extends Parcelable> T[] createTypedArray(Parcelable.Creator<T> creator) {
        int len = this.readInt();
        Parcelable[] out = (Parcelable[])creator.newArray(len);
        for (int i = 0; i < len; ++i) {
            out[i] = this.readTypedObject(creator);
        }
        return out;
    }

    public <T extends Parcelable> void writeTypedList(List<T> list) {
        this.writeInt(list.size());
        for (Parcelable value : list) {
            this.writeTypedObject(value, 0);
        }
    }

    public <T extends Parcelable> ArrayList<T> createTypedArrayList(Parcelable.Creator<T> creator) {
        int size = this.readInt();
        ArrayList<T> out = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            out.add(this.readTypedObject(creator));
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void clearPool() {
        Queue<Parcel> queue = pool;
        synchronized (queue) {
            pool.clear();
        }
    }

    private Parcel() {
    }

    private void ensureCapacity(int capacity) {
        if (this.buffer.length < capacity) {
            capacity = (int)Math.ceil((float)capacity / 1024.0f) * 1024;
            byte[] newBuffer = new byte[capacity];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.size);
            this.buffer = newBuffer;
        }
    }

    private void ensureAvailable(int avail) {
        if (this.position + avail > this.size) {
            throw new ParcelFormatException("Unable to read " + avail + " bytes at position " + this.position + " only " + (this.size - this.position) + " bytes available");
        }
    }

    private <T> Parcelable.Creator<T> getCreator(Class<T> klass) {
        if (klass.equals(String.class)) {
            return STRING_CREATOR;
        }
        try {
            Field field = klass.getDeclaredField("CREATOR");
            boolean accessible = field.isAccessible();
            field.setAccessible(true);
            Parcelable.Creator creator = (Parcelable.Creator)field.get(null);
            field.setAccessible(accessible);
            return creator;
        }
        catch (NoSuchFieldException e) {
            throw new BadParcelableException("No creator for parcelable class " + klass.getSimpleName());
        }
        catch (IllegalAccessException e) {
            throw new BadParcelableException("Unable to access creator for class " + klass.getSimpleName());
        }
    }

    private <T> Parcelable.Creator<T> readCreator(ClassLoader loader) {
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        String name = this.readString();
        try {
            return this.getCreator(loader.loadClass(name));
        }
        catch (ClassNotFoundException cfe) {
            throw new BadParcelableException(cfe);
        }
    }

    private void writeCreator(Class<?> klass) {
        this.writeString(klass.getName());
    }

    private void trim(int newSize) {
        if (newSize < this.size) {
            this.size = newSize;
        }
    }

    private void grow(int newSize) {
        if (newSize > this.size) {
            this.ensureCapacity(newSize);
            Arrays.fill(this.buffer, this.size, newSize, (byte)0);
            this.size = newSize;
        }
    }

    private void append(byte[] array, int offset, int length) {
        this.ensureCapacity(this.size + length);
        System.arraycopy(array, offset, this.buffer, this.size, length);
        this.size += length;
    }

    private static int encode(byte value, byte[] into, int offset) {
        into[offset] = value;
        return 1;
    }

    private static int encode(int value, byte[] into, int offset) {
        into[offset + 3] = (byte)((value & 0xFF000000) >>> 24);
        into[offset + 2] = (byte)((value & 0xFF0000) >>> 16);
        into[offset + 1] = (byte)((value & 0xFF00) >>> 8);
        into[offset] = (byte)(value & 0xFF);
        return 4;
    }

    private static int encode(long value, byte[] into, int offset) {
        into[offset + 7] = (byte)((value & 0xFF00000000000000L) >>> 56);
        into[offset + 6] = (byte)((value & 0xFF000000000000L) >>> 48);
        into[offset + 5] = (byte)((value & 0xFF0000000000L) >>> 40);
        into[offset + 4] = (byte)((value & 0xFF00000000L) >>> 32);
        into[offset + 3] = (byte)((value & 0xFF000000L) >>> 24);
        into[offset + 2] = (byte)((value & 0xFF0000L) >>> 16);
        into[offset + 1] = (byte)((value & 0xFF00L) >>> 8);
        into[offset] = (byte)(value & 0xFFL);
        return 8;
    }

    private static long decode(byte[] from, int offset, int bytes) {
        long result = 0L;
        switch (bytes) {
            case 8: {
                result = Parcel.valueOf(from[offset + 7]) << 56 | Parcel.valueOf(from[offset + 6]) << 48 | Parcel.valueOf(from[offset + 5]) << 40 | Parcel.valueOf(from[offset + 4]) << 32;
            }
            case 4: {
                result = result | Parcel.valueOf(from[offset + 3]) << 24 | Parcel.valueOf(from[offset + 2]) << 16 | Parcel.valueOf(from[offset + 1]) << 8 | Parcel.valueOf(from[offset]);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return result;
    }

    private static int booleanArraySizeToBytes(int size) {
        return (size + 7) / 8;
    }

    private static boolean isTrue(byte b, int pos) {
        return (b & 1 << pos) != 0;
    }

    private static boolean isTrue(byte[] arr, int pos) {
        return Parcel.isTrue(arr[pos / 8], pos % 8);
    }

    private static int setBit(int b, boolean value, int pos) {
        int bit = value ? 1 << pos : 0;
        return b | bit;
    }

    private static byte[] packBits(boolean[] arr) {
        int len = Parcel.booleanArraySizeToBytes(arr.length);
        byte[] dest = new byte[len];
        int pos = 0;
        for (int i = 0; i < len; ++i) {
            int b = 0;
            int j = 0;
            while (j < 8) {
                if (pos < arr.length) {
                    b = Parcel.setBit(b, arr[pos], j);
                }
                ++j;
                ++pos;
            }
            dest[i] = (byte)b;
        }
        return dest;
    }

    private static boolean[] unpackBits(byte[] arr, int len) {
        boolean[] out = new boolean[len];
        for (int i = 0; i < len; ++i) {
            out[i] = Parcel.isTrue(arr, i);
        }
        return out;
    }

    private static long valueOf(byte b) {
        if (b < 0) {
            return 256L + (long)b;
        }
        return b;
    }

    private byte[] chars2bytes(char[] chars) {
        byte[] out = new byte[chars.length * 2];
        for (int i = 0; i < chars.length; ++i) {
            int op = i * 2;
            out[op] = (byte)(chars[i] % 255);
            out[op + 1] = (byte)(chars[i] % 65280 >>> 8);
        }
        return out;
    }

    private char[] bytes2chars(byte[] bytes) {
        char[] out = new char[bytes.length / 2];
        for (int i = 0; i < out.length; ++i) {
            int b;
            int bp = i * 2;
            int a = bytes[bp + 1];
            if (a < 0) {
                a = 256 + a;
            }
            if ((b = bytes[bp]) < 0) {
                b = 256 + b;
            }
            out[i] = (char)(a << 8 | b);
        }
        return out;
    }
}

