/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import java.nio.charset.StandardCharsets;

public class Base64 {
    public static final int DEFAULT = 0;
    public static final int NO_PADDING = 1;
    public static final int NO_WRAP = 2;
    public static final int CRLF = 4;
    public static final int URL_SAFE = 8;
    public static final int NO_CLOSE = 16;
    protected static final int MAX_LINE_LENGTH = 76;
    protected static final byte EQUALS_SIGN = 61;
    protected static final byte CR = 13;
    protected static final byte LF = 10;
    protected static final byte WHITE_SPACE_ENC = -5;
    private static final byte EQUALS_SIGN_ENC = -1;
    private static final byte[] _STANDARD_ALPHABET = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final byte[] _STANDARD_DECODABET = new byte[]{-9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -5, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 62, -9, -9, -9, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -9, -9, -9, -1, -9, -9, -9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -9, -9, -9, -9, -9, -9, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -9, -9, -9, -9, -9};
    private static final byte[] _URL_SAFE_ALPHABET = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 95};
    private static final byte[] _URL_SAFE_DECODABET = new byte[]{-9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -5, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 62, -9, -9, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -9, -9, -9, -1, -9, -9, -9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -9, -9, -9, -9, 63, -9, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -9, -9, -9, -9, -9};

    protected static byte[] getAlphabet(int options) {
        if ((options & 8) == 8) {
            return _URL_SAFE_ALPHABET;
        }
        return _STANDARD_ALPHABET;
    }

    protected static byte[] getDecodabet(int options) {
        if ((options & 8) == 8) {
            return _URL_SAFE_DECODABET;
        }
        return _STANDARD_DECODABET;
    }

    private Base64() {
    }

    protected static int encode3to4(byte[] source, int srcOffset, int numSigBytes, byte[] destination, int destOffset, boolean noPadding, byte[] alphabet) {
        int inBuff = (numSigBytes > 0 ? source[srcOffset] << 24 >>> 8 : 0) | (numSigBytes > 1 ? source[srcOffset + 1] << 24 >>> 16 : 0) | (numSigBytes > 2 ? source[srcOffset + 2] << 24 >>> 24 : 0);
        switch (numSigBytes) {
            case 3: {
                destination[destOffset] = alphabet[inBuff >>> 18];
                destination[destOffset + 1] = alphabet[inBuff >>> 12 & 0x3F];
                destination[destOffset + 2] = alphabet[inBuff >>> 6 & 0x3F];
                destination[destOffset + 3] = alphabet[inBuff & 0x3F];
                return 4;
            }
            case 2: {
                destination[destOffset] = alphabet[inBuff >>> 18];
                destination[destOffset + 1] = alphabet[inBuff >>> 12 & 0x3F];
                destination[destOffset + 2] = alphabet[inBuff >>> 6 & 0x3F];
                if (noPadding) {
                    return 3;
                }
                destination[destOffset + 3] = 61;
                return 4;
            }
            case 1: {
                destination[destOffset] = alphabet[inBuff >>> 18];
                destination[destOffset + 1] = alphabet[inBuff >>> 12 & 0x3F];
                if (noPadding) {
                    return 2;
                }
                destination[destOffset + 2] = 61;
                destination[destOffset + 3] = 61;
                return 4;
            }
        }
        return 0;
    }

    public static String encodeToString(byte[] source, int options) {
        return Base64.encodeToString(source, 0, source.length, options);
    }

    public static String encodeToString(byte[] source, int off, int len, int options) {
        byte[] encoded = Base64.encode(source, off, len, options);
        return new String(encoded, StandardCharsets.UTF_8);
    }

    public static byte[] encode(byte[] source, int off, int len, int options) {
        int srcPos;
        if (source == null) {
            throw new NullPointerException("Cannot serialize a null array.");
        }
        if (off < 0) {
            throw new IllegalArgumentException("Cannot have negative offset: " + off);
        }
        if (len < 0) {
            throw new IllegalArgumentException("Cannot have length offset: " + len);
        }
        if (off + len > source.length) {
            throw new IllegalArgumentException(String.format("Cannot have offset of %d and length of %d with array of length %d", off, len, source.length));
        }
        if (len == 0) {
            return new byte[0];
        }
        boolean breakLines = (options & 2) == 0;
        boolean crlf = (options & 4) != 0;
        boolean noPadding = (options & 1) != 0;
        byte[] alphabet = Base64.getAlphabet(options);
        int bufLen = len / 3 * 4 + (len % 3 > 0 ? 4 : 0);
        if (breakLines) {
            int lines = bufLen / 76;
            bufLen += crlf ? lines * 2 : lines;
        }
        byte[] dest = new byte[bufLen];
        int destPos = 0;
        int lineLength = 0;
        int len2 = len - 2;
        for (srcPos = 0; srcPos < len2; srcPos += 3) {
            if (breakLines && lineLength >= 76) {
                if (crlf) {
                    dest[destPos++] = 13;
                }
                dest[destPos++] = 10;
                lineLength = 0;
            }
            int l = Base64.encode3to4(source, srcPos + off, 3, dest, destPos, noPadding, alphabet);
            destPos += l;
            lineLength += l;
        }
        if (srcPos < len) {
            if (breakLines && lineLength >= 76) {
                if (crlf) {
                    dest[destPos++] = 13;
                }
                dest[destPos++] = 10;
            }
            destPos += Base64.encode3to4(source, srcPos + off, len - srcPos, dest, destPos, noPadding, alphabet);
        }
        if (destPos < dest.length) {
            byte[] finalOut = new byte[destPos];
            System.arraycopy(dest, 0, finalOut, 0, destPos);
            return finalOut;
        }
        return dest;
    }

    public static byte[] encode(byte[] source, int options) {
        return Base64.encode(source, 0, source.length, options);
    }

    protected static int decode4to3(byte[] src, int srcOffset, int srcLen, byte[] dest, int destOffset, byte[] decodabet) {
        if (srcLen < 2) {
            throw new IllegalArgumentException(String.format("Source array with length %d cannot have offset of %d.", src.length, srcOffset));
        }
        if (srcOffset < 0 || srcOffset + srcLen > src.length) {
            throw new IllegalArgumentException(String.format("Source array with length %d cannot have offset of %d and still process four bytes.", src.length, srcOffset));
        }
        if (destOffset < 0 || destOffset + (srcLen - 1) > dest.length) {
            throw new IllegalArgumentException(String.format("Destination array with length %d cannot have offset of %d and still store three bytes.", dest.length, destOffset));
        }
        if (srcLen == 2 || src[srcOffset + 2] == 61 && src[srcOffset + 3] == 61) {
            int outBuff = Base64.validate(decodabet, src[srcOffset]) << 18 | Base64.validate(decodabet, src[srcOffset + 1]) << 12;
            dest[destOffset] = (byte)(outBuff >>> 16);
            return 1;
        }
        if (srcLen == 3 || src[srcOffset + 3] == 61) {
            int outBuff = Base64.validate(decodabet, src[srcOffset]) << 18 | Base64.validate(decodabet, src[srcOffset + 1]) << 12 | Base64.validate(decodabet, src[srcOffset + 2]) << 6;
            dest[destOffset] = (byte)(outBuff >>> 16);
            dest[destOffset + 1] = (byte)(outBuff >>> 8);
            return 2;
        }
        int outBuff = Base64.validate(decodabet, src[srcOffset]) << 18 | Base64.validate(decodabet, src[srcOffset + 1]) << 12 | Base64.validate(decodabet, src[srcOffset + 2]) << 6 | Base64.validate(decodabet, src[srcOffset + 3]);
        dest[destOffset] = (byte)(outBuff >> 16);
        dest[destOffset + 1] = (byte)(outBuff >> 8);
        dest[destOffset + 2] = (byte)outBuff;
        return 3;
    }

    private static int validate(byte[] decodabet, byte from) {
        byte b = decodabet[from & 0x7F];
        if (b < 0) {
            throw new IllegalArgumentException(String.format("Invalid%s base64 character \\u%04d", decodabet == _URL_SAFE_DECODABET ? " url safe" : "", b & 0xFF));
        }
        return b;
    }

    public static byte[] decode(byte[] source, int options) {
        return Base64.decode(source, 0, source.length, options);
    }

    public static byte[] decode(byte[] source, int offset, int len, int options) {
        if (source == null) {
            throw new NullPointerException("Cannot decode null source array.");
        }
        if (offset < 0 || offset + len > source.length) {
            throw new IllegalArgumentException(String.format("Source array with length %d cannot have offset of %d and process %d bytes.", source.length, offset, len));
        }
        if (len == 0) {
            return new byte[0];
        }
        byte[] decodabet = Base64.getDecodabet(options);
        int len34 = len * 3 / 4;
        byte[] outBuff = new byte[len34];
        int outBuffPosn = 0;
        byte[] b4 = new byte[4];
        int b4Posn = 0;
        for (int i = offset; i < offset + len; ++i) {
            byte sbiDecode = decodabet[source[i] & 0x7F];
            if (sbiDecode >= -5) {
                if (sbiDecode < -1) continue;
                b4[b4Posn++] = source[i];
                if (b4Posn <= 3) continue;
                outBuffPosn += Base64.decode4to3(b4, 0, 4, outBuff, outBuffPosn, decodabet);
                b4Posn = 0;
                continue;
            }
            throw new IllegalArgumentException(String.format("Bad Base64 input character decimal %d in array position %d", source[i] & 0xFF, i));
        }
        if (b4Posn > 0) {
            outBuffPosn += Base64.decode4to3(b4, 0, b4Posn, outBuff, outBuffPosn, decodabet);
        }
        if (outBuffPosn < outBuff.length) {
            byte[] out = new byte[outBuffPosn];
            System.arraycopy(outBuff, 0, out, 0, outBuffPosn);
            return out;
        }
        return outBuff;
    }

    public static byte[] decode(String s, int options) {
        if (s == null) {
            throw new NullPointerException("Input string was null.");
        }
        byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
        return Base64.decode(bytes, 0, bytes.length, options);
    }
}

