/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.util.Base64;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Base64OutputStream
extends FilterOutputStream {
    private final byte[] buffer;
    private final byte[] b4;
    private final boolean breakLines;
    private final boolean crlf;
    private final byte[] alphabet;
    private final boolean noPadding;
    private final boolean close;
    private int position;
    private int lineLength;

    public Base64OutputStream(OutputStream out, int options) {
        super(out);
        this.breakLines = (options & 2) == 0;
        this.alphabet = Base64.getAlphabet(options);
        this.noPadding = (options & 1) != 0;
        this.close = (options & 0x10) == 0;
        this.crlf = (options & 4) != 0;
        this.buffer = new byte[3];
        this.position = 0;
        this.lineLength = 0;
        this.b4 = new byte[4];
    }

    @Override
    public void write(int theByte) throws IOException {
        if (this.out == null) {
            throw new IOException("Writing to closed Base64OutputStream");
        }
        this.buffer[this.position++] = (byte)theByte;
        if (this.position >= 3) {
            if (this.breakLines && this.lineLength >= 76) {
                if (this.crlf) {
                    this.out.write(13);
                }
                this.out.write(10);
                this.lineLength = 0;
            }
            Base64.encode3to4(this.buffer, 0, 3, this.b4, 0, this.noPadding, this.alphabet);
            this.out.write(this.b4, 0, 4);
            this.lineLength += 4;
            this.position = 0;
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.out == null) {
            throw new IOException("Flushing a closed Base64OutputStream");
        }
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.out != null) {
            IOException ex = null;
            try {
                if (this.position > 0) {
                    if (this.breakLines && this.lineLength >= 76) {
                        if (this.crlf) {
                            this.out.write(13);
                        }
                        this.out.write(10);
                    }
                    int len = Base64.encode3to4(this.buffer, 0, this.position, this.b4, 0, this.noPadding, this.alphabet);
                    this.out.write(this.b4, 0, len);
                }
                this.out.flush();
            }
            catch (IOException e) {
                ex = e;
            }
            try {
                if (this.close) {
                    this.out.close();
                }
            }
            finally {
                this.out = null;
            }
            if (ex != null) {
                throw new IOException(ex);
            }
        }
    }
}

