/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.testing;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.morimekta.util.Strings;
import net.morimekta.util.io.IOUtils;

public class IntegrationExecutor {
    private final File jarFile;
    private final Runtime runtime;
    private final ExecutorService executor;
    private final ByteArrayOutputStream out;
    private final ByteArrayOutputStream err;
    private IOException inException;
    private IOException outException;
    private IOException errException;
    private InputStream in;
    private long deadlineMs;

    public IntegrationExecutor(String module, String name) throws IOException {
        this(IntegrationExecutor.findMavenTargetJar(module, name), Runtime.getRuntime(), Executors.newFixedThreadPool(3));
    }

    protected IntegrationExecutor(File jarFile, Runtime runtime, ExecutorService executor) {
        this.jarFile = jarFile;
        this.runtime = runtime;
        this.executor = executor;
        this.out = new ByteArrayOutputStream();
        this.err = new ByteArrayOutputStream();
        this.in = null;
        this.deadlineMs = TimeUnit.SECONDS.toMillis(1L);
    }

    public String getOutput() {
        return new String(this.out.toByteArray(), StandardCharsets.UTF_8);
    }

    public String getError() {
        return new String(this.err.toByteArray(), StandardCharsets.UTF_8);
    }

    public void setInput(InputStream in) {
        this.in = in;
    }

    public void setDeadlineMs(long deadlineMs) {
        this.deadlineMs = deadlineMs;
    }

    public int run(String ... args) throws IOException {
        try {
            this.out.reset();
            this.err.reset();
            this.inException = null;
            this.outException = null;
            this.errException = null;
            String[] cmd = new String[args.length + 3];
            cmd[0] = "java";
            cmd[1] = "-jar";
            cmd[2] = this.jarFile.getCanonicalPath();
            if (args.length > 0) {
                System.arraycopy(args, 0, cmd, 3, args.length);
            }
            Process process = this.runtime.exec(cmd);
            this.executor.submit(() -> {
                try {
                    IOUtils.copy((InputStream)process.getInputStream(), (OutputStream)this.out);
                }
                catch (IOException e) {
                    this.outException = e;
                }
            });
            this.executor.submit(() -> {
                try {
                    IOUtils.copy((InputStream)process.getErrorStream(), (OutputStream)this.err);
                }
                catch (IOException e) {
                    this.errException = e;
                }
            });
            if (this.in != null) {
                this.executor.submit(() -> {
                    try {
                        IOUtils.copy((InputStream)this.in, (OutputStream)process.getOutputStream());
                        process.getOutputStream().flush();
                    }
                    catch (IOException e) {
                        this.inException = e;
                    }
                    finally {
                        try {
                            process.getOutputStream().close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                        this.in = null;
                    }
                });
            } else {
                process.getOutputStream().close();
            }
            if (this.deadlineMs > 0L) {
                if (!process.waitFor(this.deadlineMs, TimeUnit.MILLISECONDS)) {
                    process.destroyForcibly();
                    StringBuilder bld = new StringBuilder();
                    boolean first = true;
                    for (String c : cmd) {
                        if (first) {
                            first = false;
                        } else {
                            bld.append(" ");
                        }
                        String esc = Strings.escape((CharSequence)c);
                        if (!c.equals(esc) || c.contains(" ")) {
                            bld.append('\"').append(esc).append('\"');
                            continue;
                        }
                        bld.append(c);
                    }
                    throw new IOException("Process took too long: " + bld.toString());
                }
            } else {
                process.waitFor();
            }
            if (this.inException != null) {
                throw new IOException(this.inException.getMessage(), this.inException);
            }
            if (this.outException != null) {
                throw new IOException(this.outException.getMessage(), this.outException);
            }
            if (this.errException != null) {
                throw new IOException(this.errException.getMessage(), this.errException);
            }
            return process.exitValue();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    private static File findMavenTargetJar(String module, String name) throws IOException {
        File inModule;
        if (new File(module).isDirectory() && (inModule = new File(module + "/target/" + name)).isFile()) {
            return inModule;
        }
        File local = new File("target/" + name);
        if (local.isFile()) {
            return local;
        }
        throw new IOException("No such jar file: " + name);
    }
}

