/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.testing;

import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.apache.ApacheHttpTransport;
import java.io.IOException;
import java.net.ServerSocket;
import org.junit.Assert;

public class NetworkUtils {
    public static int findFreePort() {
        int port = -1;
        try (ServerSocket socket = new ServerSocket(0);){
            port = socket.getLocalPort();
        }
        catch (IOException e) {
            Assert.fail((String)"Unable to locate free port.");
        }
        return port;
    }

    public static HttpRequestFactory httpFactory() {
        return NetworkUtils.httpTransport().createRequestFactory();
    }

    public static HttpRequestFactory httpFactory(HttpRequestInitializer initializer) {
        return NetworkUtils.httpTransport().createRequestFactory(initializer);
    }

    public static HttpTransport httpTransport() {
        return new ApacheHttpTransport();
    }

    private NetworkUtils() {
    }
}

