/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.testing.matchers;

import java.util.Objects;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.junit.Assert;

public class IsEqualIgnoreIndent
extends BaseMatcher<String> {
    private final String expected;

    public IsEqualIgnoreIndent(String expected) {
        Assert.assertNotNull((String)"Missing expected.", (Object)expected);
        this.expected = expected;
    }

    public boolean matches(Object o) {
        if (o == null || !CharSequence.class.isAssignableFrom(o.getClass())) {
            return false;
        }
        String noIndentActual = o.toString().replaceAll("\\r?\\n[ \\t]*", "\n");
        String noIndentExpected = this.expected.replaceAll("\\r?\\n[ \\t]*", "\n");
        return noIndentActual.equals(noIndentExpected);
    }

    public void describeTo(Description description) {
        description.appendText("isEqualIgnoreIndent(" + this.expected + ")");
    }

    public void describeMismatch(Object actual, Description mismatchDescription) {
        mismatchDescription.appendText("was " + Objects.toString(actual));
    }
}

