/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.testing.matchers;

import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.junit.Assert;

public class IsInRange
extends BaseMatcher<Number> {
    private final Number lowerInclusive;
    private final Number higherExclusive;

    public IsInRange(Number lowerInclusive, Number higherExclusive) {
        Assert.assertNotNull((String)"Missing lower bound of range.", (Object)lowerInclusive);
        Assert.assertNotNull((String)"Missing upper bound of range.", (Object)higherExclusive);
        Assert.assertTrue((String)String.format("Lower bound %s not lower than upper bound %s of range.", lowerInclusive, higherExclusive), (lowerInclusive.doubleValue() < higherExclusive.doubleValue() ? 1 : 0) != 0);
        this.lowerInclusive = lowerInclusive;
        this.higherExclusive = higherExclusive;
    }

    public boolean matches(Object o) {
        if (o == null || !(o instanceof Number)) {
            return false;
        }
        Number actual = (Number)o;
        return this.lowerInclusive.doubleValue() <= actual.doubleValue() && actual.doubleValue() < this.higherExclusive.doubleValue();
    }

    public void describeTo(Description description) {
        description.appendText("range(" + this.lowerInclusive + " <= x < " + this.higherExclusive + ")");
    }

    public void describeMismatch(Object actual, Description mismatchDescription) {
        mismatchDescription.appendText("was " + actual);
    }
}

