/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.testing.time;

import java.time.Clock;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class FakeClock
extends Clock {
    private static final Clock systemUTC = Clock.systemUTC();
    private final AtomicReference<LocalDateTime> currentTimeUTC;
    private final ZoneId zoneId;

    public FakeClock() {
        this.currentTimeUTC = new AtomicReference<LocalDateTime>(LocalDateTime.now(systemUTC));
        this.zoneId = systemUTC.getZone();
    }

    private FakeClock(AtomicReference<LocalDateTime> currentTimeUTC, ZoneId zoneId) {
        this.currentTimeUTC = currentTimeUTC;
        this.zoneId = zoneId;
    }

    public static FakeClock forCurrentTimeMillis(long millis) {
        Clock clock = Clock.fixed(Instant.ofEpochMilli(millis), systemUTC.getZone());
        return new FakeClock(new AtomicReference<LocalDateTime>(LocalDateTime.now(clock)), Clock.systemUTC().getZone());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick(long millis) {
        AtomicReference<LocalDateTime> atomicReference = this.currentTimeUTC;
        synchronized (atomicReference) {
            this.currentTimeUTC.set(this.currentTimeUTC.get().plus(millis, ChronoUnit.MILLIS));
        }
    }

    public void tick(long time, TimeUnit unit) {
        this.tick(Math.max(unit.toMillis(time), 1L));
    }

    @Override
    public ZoneId getZone() {
        return this.zoneId;
    }

    @Override
    public FakeClock withZone(ZoneId zoneId) {
        return new FakeClock(this.currentTimeUTC, zoneId);
    }

    @Override
    public Instant instant() {
        return this.currentTimeUTC.get().atZone(this.zoneId).toInstant();
    }
}

