/*
 * Decompiled with CFR 0.152.
 */
package net.moznion.mysql.diff;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.moznion.mysql.diff.DiffExtractor;
import net.moznion.mysql.diff.MySqlConnectionInfo;
import net.moznion.mysql.diff.SchemaDumper;
import net.moznion.mysql.diff.SchemaParser;
import net.moznion.mysql.diff.model.Table;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.spi.StringArrayOptionHandler;

public class App {
    @Option(name="-v", aliases={"--version"}, usage="print version")
    private boolean showVersion;
    @Option(name="-h", aliases={"--help"}, usage="print usage message and exit")
    private boolean showUsage;
    @Argument(index=0, metaVar="arguments...", handler=StringArrayOptionHandler.class)
    private String[] arguments;

    public static void main(String[] args) throws IOException, SQLException, InterruptedException {
        App app = new App();
        CmdLineParser parser = new CmdLineParser((Object)app);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            throw new IllegalArgumentException("Invalid arguments are detected: " + Arrays.asList(args));
        }
        if (app.showVersion) {
            System.out.println(Optional.ofNullable(App.class.getPackage().getImplementationVersion()).orElse("Missing Version"));
            return;
        }
        if (app.showUsage) {
            System.out.println(App.getUsageMessage());
            return;
        }
        List<Object> coreArgs = Arrays.asList((Object[])Optional.ofNullable(args).orElse(new String[0]));
        int numOfArgs = coreArgs.size();
        if (numOfArgs != 2) {
            if (numOfArgs < 2) {
                System.err.println("[ERROR] Too few command line arguments");
            } else {
                System.err.println("[ERROR] Too many command line arguments");
            }
            System.err.println();
            System.err.println(App.getUsageMessage());
            System.exit(1);
        }
        ArrayList<List<Table>> parsed = new ArrayList<List<Table>>();
        for (String string : coreArgs) {
            String schema;
            SchemaDumper schemaDumper = new SchemaDumper();
            File file = new File(string);
            if (file.exists()) {
                schema = schemaDumper.dump(file);
            } else if (string.contains(" ")) {
                App app2 = new App();
                app2.getClass();
                RemoteDbArg remoteDbArg = app2.new RemoteDbArg();
                CmdLineParser remoteDbArgParser = new CmdLineParser((Object)remoteDbArg);
                try {
                    remoteDbArgParser.parseArgument(string.substring(1, string.length() - 1).split(" "));
                }
                catch (CmdLineException e) {
                    throw new IllegalArgumentException("Invalid remote DB argument is detected: " + string);
                }
                if (remoteDbArg.dbName == null || remoteDbArg.dbName.isEmpty()) {
                    throw new IllegalArgumentException("Invalid remote DB argument is detected: " + string);
                }
                MySqlConnectionInfo.Builder mysqlConnectionInfoBuilder = MySqlConnectionInfo.builder();
                if (remoteDbArg.host != null) {
                    mysqlConnectionInfoBuilder.host(remoteDbArg.host);
                }
                if (remoteDbArg.user != null) {
                    mysqlConnectionInfoBuilder.user(remoteDbArg.user);
                }
                if (remoteDbArg.pass != null) {
                    mysqlConnectionInfoBuilder.pass(remoteDbArg.pass);
                }
                schema = schemaDumper.dumpFromRemoteDb(remoteDbArg.dbName, mysqlConnectionInfoBuilder.build());
            } else {
                schema = schemaDumper.dumpFromLocalDb(string);
            }
            parsed.add(SchemaParser.parse(schema));
        }
        String diff = DiffExtractor.extractDiff((List)parsed.get(0), (List)parsed.get(1));
        System.out.println(diff);
    }

    private static String getUsageMessage() {
        return "[Usage]\n    java -jar [old_database] [new_database]\n[Examples]\n* Take diff between createtable1.sql and createtable2.sql (both of SQL files on your machine)\n    java -jar createtable1.sql createtable2.sql\n* Take diff between dbname1 and dbname2 (both of databases on the local MySQL)\n    java -jar dbname1 dbname2\n* Take diff between dbname1 and dbname2 (both of databases on remote MySQL)\n    java -jar '-u root -h localhost dbname1' '-u root -h localhost dbname2'\n[Options]\n    -h, --help:    Show usage\n    -v, --version: Show version";
    }

    private class RemoteDbArg {
        @Option(name="-h", aliases={"--host"}, metaVar="host", usage="specify host")
        private String host;
        @Option(name="-u", aliases={"--user"}, metaVar="user", usage="specify user")
        private String user;
        @Option(name="-p", aliases={"--password"}, metaVar="pass", usage="specify password")
        private String pass;
        @Argument(index=0, metaVar="dbName")
        private String dbName;

        private RemoteDbArg() {
        }

        public String getHost() {
            return this.host;
        }

        public String getUser() {
            return this.user;
        }

        public String getPass() {
            return this.pass;
        }

        public String getDbName() {
            return this.dbName;
        }
    }
}

