/*
 * Decompiled with CFR 0.152.
 */
package net.moznion.mysql.diff;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.moznion.mysql.diff.model.Column;
import net.moznion.mysql.diff.model.OrdinaryKey;
import net.moznion.mysql.diff.model.Table;
import net.moznion.mysql.diff.model.UniqueKey;

public class DiffExtractor {
    public static String extractDiff(List<Table> oldTables, List<Table> newTables) {
        StringBuilder diffStringBuilder = new StringBuilder();
        List newTableNames = newTables.stream().map(table -> table.getTableName()).sorted().collect(Collectors.toList());
        Map<String, Table> oldTableMap = oldTables.stream().collect(Collectors.toMap(Table::getTableName, t -> t));
        Map<String, Table> newTableMap = newTables.stream().collect(Collectors.toMap(Table::getTableName, t -> t));
        for (String tableName : newTableNames) {
            Table newTable = newTableMap.get(tableName);
            if (oldTableMap.containsKey(tableName)) {
                Table oldTable = oldTableMap.get(tableName);
                diffStringBuilder.append(DiffExtractor.extractTableDiff(tableName, oldTable, newTable));
                continue;
            }
            diffStringBuilder.append(newTable.getContent()).append(";\n\n");
        }
        return diffStringBuilder.toString();
    }

    private static String extractTableDiff(String tableName, Table oldTable, Table newTable) {
        List<String> changes = DiffExtractor.extractColumnDiff(oldTable, newTable);
        changes.addAll(DiffExtractor.extractKeyDiff(oldTable, newTable));
        if (changes.isEmpty()) {
            return "";
        }
        return "ALTER TABLE `" + tableName + "` " + String.join((CharSequence)", ", changes) + ";\n\n";
    }

    private static List<String> extractColumnDiff(Table oldTable, Table newTable) {
        List<Column> oldColumns = oldTable.getColumns();
        List<Column> newColumns = newTable.getColumns();
        Map<String, Column> oldColumnMap = oldColumns.stream().collect(Collectors.toMap(Column::getName, c -> c));
        Map<String, Column> newColumnMap = newColumns.stream().collect(Collectors.toMap(Column::getName, c -> c));
        HashMap<String, Column> allColumnMap = new HashMap<String, Column>();
        allColumnMap.putAll(oldColumnMap);
        allColumnMap.putAll(newColumnMap);
        ArrayList<String> changes = new ArrayList<String>();
        for (Map.Entry column : allColumnMap.entrySet()) {
            String newDefinition;
            String columnName = (String)column.getKey();
            if (!oldColumnMap.containsKey(columnName)) {
                changes.add("ADD `" + columnName + "` " + newColumnMap.get(columnName).getDefinition());
                continue;
            }
            if (!newColumnMap.containsKey(columnName)) {
                changes.add("DROP `" + columnName + "`");
                continue;
            }
            String oldDefinition = oldColumnMap.get(columnName).getDefinition();
            if (oldDefinition.equals(newDefinition = newColumnMap.get(columnName).getDefinition())) continue;
            changes.add("MODIFY `" + columnName + "` " + newDefinition);
        }
        return changes;
    }

    private static List<String> extractKeyDiff(Table oldTable, Table newTable) {
        ArrayList<String> changes = new ArrayList<String>();
        changes.addAll(DiffExtractor.extractOrdinaryKeyDiff(oldTable, newTable));
        changes.addAll(DiffExtractor.extractUniqueKeyDiff(oldTable, newTable));
        return changes;
    }

    private static List<String> extractOrdinaryKeyDiff(Table oldTable, Table newTable) {
        String column;
        ArrayList<String> changes = new ArrayList<String>();
        List<OrdinaryKey> oldKeys = oldTable.getKeys();
        List<OrdinaryKey> newKeys = newTable.getKeys();
        Set oldKeysAttendance = oldKeys.stream().map(OrdinaryKey::getColumn).collect(Collectors.toSet());
        Set newKeysAttendance = newKeys.stream().map(OrdinaryKey::getColumn).collect(Collectors.toSet());
        for (OrdinaryKey key : newKeys) {
            column = key.getColumn();
            if (oldKeysAttendance.contains(column)) continue;
            String name = String.join((CharSequence)"_", Arrays.stream(column.split(",")).map(col -> col.replaceAll("[`()]", "")).collect(Collectors.toList()));
            changes.add("ADD INDEX `" + name + "` (" + column + ")");
        }
        for (OrdinaryKey key : oldKeys) {
            column = key.getColumn();
            if (newKeysAttendance.contains(column)) continue;
            changes.add("DROP INDEX `" + key.getName() + "`");
        }
        return changes;
    }

    private static List<String> extractUniqueKeyDiff(Table oldTable, Table newTable) {
        String column;
        ArrayList<String> changes = new ArrayList<String>();
        List<UniqueKey> oldKeys = oldTable.getUniqueKeys();
        List<UniqueKey> newKeys = newTable.getUniqueKeys();
        Set oldKeysAtendance = oldKeys.stream().map(OrdinaryKey::getColumn).collect(Collectors.toSet());
        Set newKeysAtendance = newKeys.stream().map(OrdinaryKey::getColumn).collect(Collectors.toSet());
        for (UniqueKey uniqueKey : newKeys) {
            column = uniqueKey.getColumn();
            if (oldKeysAtendance.contains(column)) continue;
            String name = String.join((CharSequence)"_", Arrays.asList(column.split(",")).stream().map(col -> col.replaceAll("[`()]", "")).collect(Collectors.toList()));
            changes.add("ADD UNIQUE INDEX `" + name + "` (" + column + ")");
        }
        for (OrdinaryKey ordinaryKey : oldKeys) {
            column = ordinaryKey.getColumn();
            if (newKeysAtendance.contains(column)) continue;
            changes.add("DROP INDEX `" + ordinaryKey.getName() + "`");
        }
        return changes;
    }
}

