/*
 * Decompiled with CFR 0.152.
 */
package net.moznion.mysql.diff;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.moznion.mysql.diff.MySqlConnectionUri;

public class MySqlConnectionInfo {
    private final String host;
    private final String user;
    private final String pass;
    private final String jdbcUrl;

    public static Builder builder() {
        return new Builder();
    }

    private MySqlConnectionInfo(Builder builder) {
        this.host = builder.host;
        this.user = builder.user;
        this.pass = builder.pass;
        this.jdbcUrl = "jdbc:mysql://" + builder.host + ":" + builder.port + "?" + String.join((CharSequence)"&", builder.properties);
    }

    public String getHost() {
        return this.host;
    }

    public String getUser() {
        return this.user;
    }

    public String getPass() {
        return this.pass;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public static class Builder {
        private String host = "localhost";
        private int port = 3306;
        private String user = "root";
        private String pass = "";
        private List<String> properties = new ArrayList<String>(Arrays.asList("allowMultiQueries=true"));

        public void addProperty(String property) {
            this.properties.add(property);
        }

        public void addProperties(List<String> properties) {
            this.properties.addAll(properties);
        }

        public Builder url(String url) throws URISyntaxException {
            MySqlConnectionUri connectionUri = new MySqlConnectionUri(url);
            this.host = connectionUri.getHost();
            this.port = connectionUri.getPort();
            this.addProperties(connectionUri.getQueries());
            return this;
        }

        public MySqlConnectionInfo build() {
            return new MySqlConnectionInfo(this);
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder pass(String pass) {
            this.pass = pass;
            return this;
        }
    }
}

