/*
 * Decompiled with CFR 0.152.
 */
package net.moznion.mysql.diff;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class MySqlConnectionUri {
    private String host;
    private int port;
    private List<String> queries;
    private static final int DEFAULT_PORT = 3306;
    private static final Pattern URL_PATTERN = Pattern.compile("^([^/]*:)[^:/]+:");

    public MySqlConnectionUri(String url) throws URISyntaxException {
        Matcher urlMatcher = URL_PATTERN.matcher(url);
        if (!urlMatcher.find()) {
            throw new URISyntaxException(url, "It doesn't contain connection protocol schema of jdbc");
        }
        String cleanUrl = url.substring(urlMatcher.group(1).length());
        URI uri = new URI(cleanUrl);
        this.host = uri.getHost();
        this.port = uri.getPort();
        if (this.port < 0) {
            this.port = 3306;
        }
        this.queries = this.parseQueryString(uri.getQuery());
    }

    private List<String> parseQueryString(String queryString) {
        ArrayList<String> queries = new ArrayList<String>();
        if (queryString != null) {
            Arrays.asList(queryString.split("&")).forEach(property -> queries.add((String)property));
        }
        return queries;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public List<String> getQueries() {
        return this.queries;
    }
}

